/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import genetics.api.individual.IGenome;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class AlleleEffectFertile
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 5;

    public AlleleEffectFertile() {
        super("fertile", false, 6, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vector3i area = AlleleEffectFertile.getModifiedArea(genome, housing);
        int blockX = AlleleEffectFertile.getRandomOffset(world.field_73012_v, housingCoordinates.func_177958_n(), area.func_177958_n());
        int blockZ = AlleleEffectFertile.getRandomOffset(world.field_73012_v, housingCoordinates.func_177952_p(), area.func_177952_p());
        int blockMaxY = housingCoordinates.func_177956_o() + area.func_177956_o() / 2 + 1;
        int blockMinY = housingCoordinates.func_177956_o() - area.func_177956_o() / 2 - 1;
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (world.func_72863_F().func_217205_a(blockX >> 4, blockZ >> 4, false) == null) continue;
            if (AlleleEffectFertile.tryTickColumn(world, blockX, blockZ, blockMaxY, blockMinY)) break;
            blockX = AlleleEffectFertile.getRandomOffset(world.field_73012_v, housingCoordinates.func_177958_n(), area.func_177958_n());
            blockZ = AlleleEffectFertile.getRandomOffset(world.field_73012_v, housingCoordinates.func_177952_p(), area.func_177952_p());
        }
        return storedData;
    }

    private static int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private static boolean tryTickColumn(World world, int x, int z, int maxY, int minY) {
        for (int y = maxY; y >= minY; --y) {
            BlockState state = world.func_180495_p(new BlockPos(x, y, z));
            Block block = state.func_177230_c();
            if (!block.func_149653_t(state) || !(block instanceof IGrowable) && !(block instanceof IPlantable)) continue;
            world.func_205220_G_().func_205360_a(new BlockPos(x, y, z), (Object)block, 5);
            return true;
        }
        return false;
    }
}

