/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import forestry.core.utils.VectUtil;
import genetics.api.individual.IGenome;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AlleleEffectFungification
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public AlleleEffectFungification() {
        super("mycophilic", true, 20, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData && ((EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            AlleleEffectFungification.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IGenome genome, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vector3i area = AlleleEffectFungification.getModifiedArea(genome, housing);
        Vector3i halfArea = new Vector3i(area.func_177958_n() / 2, area.func_177956_o() / 2, area.func_177952_p() / 2);
        for (int attempt = 0; attempt < 10; ++attempt) {
            BlockPos pos = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177973_b(halfArea).func_177971_a((Vector3i)housingCoordinates);
            if (!world.func_175667_e(pos)) continue;
            BlockState blockState = world.func_180495_p(pos);
            if (AlleleEffectFungification.convertToMycelium(world, blockState, pos)) {
                return;
            }
            if (!AlleleEffectFungification.growGiantMushroom((ServerWorld)world, blockState, pos)) continue;
            return;
        }
    }

    private static void doEntityEffect(IGenome genome, IBeeHousing housing) {
        List<CowEntity> cows = AlleleEffectFungification.getEntitiesInRange(genome, housing, CowEntity.class);
        for (CowEntity cow : cows) {
            if (!AlleleEffectFungification.convertCowToMooshroom(cow)) continue;
            return;
        }
    }

    private static boolean convertToMycelium(World world, BlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d && world.func_175710_j(pos)) {
            world.func_175656_a(pos, Blocks.field_150391_bh.func_176223_P());
            return true;
        }
        return false;
    }

    private static boolean growGiantMushroom(ServerWorld world, BlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block instanceof MushroomBlock) {
            MushroomBlock mushroom = (MushroomBlock)block;
            mushroom.func_226940_a_(world, pos, blockState, world.field_73012_v);
            return true;
        }
        return false;
    }

    private static boolean convertCowToMooshroom(CowEntity cow) {
        if (cow instanceof MooshroomEntity) {
            return false;
        }
        World world = cow.field_70170_p;
        cow.func_70106_y();
        MooshroomEntity mooshroom = new MooshroomEntity(EntityType.field_200780_T, world);
        mooshroom.func_70012_b(cow.func_226277_ct_(), cow.func_226278_cu_(), cow.func_226281_cx_(), cow.field_70177_z, cow.field_70125_A);
        mooshroom.func_70606_j(cow.func_110143_aJ());
        mooshroom.field_70761_aq = cow.field_70761_aq;
        world.func_217376_c((Entity)mooshroom);
        world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, cow.func_226277_ct_(), cow.func_226278_cu_() + (double)(cow.func_213302_cg() / 2.0f), cow.func_226281_cx_(), 0.0, 0.0, 0.0);
        return true;
    }
}

