/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;
import genetics.api.individual.IGenome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class AlleleEffectResurrection
extends AlleleEffectThrottled {
    private final List<Resurrectable<? extends MobEntity>> resurrectables;

    public static List<Resurrectable<? extends MobEntity>> getReanimationList() {
        ArrayList<Resurrectable<? extends MobEntity>> list = new ArrayList<Resurrectable<? extends MobEntity>>();
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151103_aS), EntityType.field_200741_ag));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151032_g), EntityType.field_200741_ag));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151078_bh), EntityType.field_200725_aD));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151072_bj), EntityType.field_200792_f));
        return list;
    }

    public static List<Resurrectable<? extends MobEntity>> getResurrectionList() {
        ArrayList<Resurrectable<? extends MobEntity>> list = new ArrayList<Resurrectable<? extends MobEntity>>();
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151016_H), EntityType.field_200797_k));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151079_bi), EntityType.field_200803_q));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151007_F), EntityType.field_200748_an));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151070_bp), EntityType.field_200748_an));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151007_F), EntityType.field_200794_h));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151070_bp), EntityType.field_200794_h));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Items.field_151073_bk), EntityType.field_200811_y));
        list.add(new Resurrectable(new ItemStack((IItemProvider)Blocks.field_150380_bt), EntityType.field_200802_p, dragon -> dragon.func_184670_cT().func_188758_a(PhaseType.field_188741_a)));
        return list;
    }

    public AlleleEffectResurrection(String name, List<Resurrectable<? extends MobEntity>> resurrectables) {
        super(name, true, 40, true, true);
        this.resurrectables = resurrectables;
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        List<ItemEntity> entities = AlleleEffectResurrection.getEntitiesInRange(genome, housing, ItemEntity.class);
        if (entities.isEmpty()) {
            return storedData;
        }
        Collections.shuffle(this.resurrectables);
        for (ItemEntity entity : entities) {
            if (this.resurrectEntity(entity)) break;
        }
        return storedData;
    }

    private boolean resurrectEntity(ItemEntity entity) {
        if (!entity.func_70089_S()) {
            return false;
        }
        ItemStack contained = entity.func_92059_d();
        for (Resurrectable<? extends MobEntity> entry : this.resurrectables) {
            if (!ItemStackUtil.isIdenticalItem(((Resurrectable)entry).res, contained)) continue;
            if (((Resurrectable)entry).spawnAndTransform(entity)) {
                contained.func_190918_g(1);
                if (contained.func_190916_E() <= 0) {
                    entity.func_70106_y();
                }
            }
            return true;
        }
        return false;
    }

    private static class Resurrectable<T extends MobEntity> {
        private final ItemStack res;
        private final EntityType<T> risen;
        private final Consumer<T> risenTransformer;

        private Resurrectable(ItemStack res, EntityType<T> risen) {
            this(res, risen, (T e) -> {});
        }

        private Resurrectable(ItemStack res, EntityType<T> risen, Consumer<T> risenTransformer) {
            this.res = res;
            this.risen = risen;
            this.risenTransformer = risenTransformer;
        }

        private boolean spawnAndTransform(ItemEntity entity) {
            EntityType<T> spawnedEntity = EntityUtil.spawnEntity(entity.field_70170_p, this.risen, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            if (spawnedEntity != null) {
                this.risenTransformer.accept(spawnedEntity);
                return true;
            }
            return false;
        }
    }
}

