/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.climate.IClimateListener;
import forestry.apiculture.features.ApicultureContainers;
import forestry.apiculture.gui.ContainerBeeHelper;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.climate.ClimateRoot;
import forestry.core.gui.ContainerTile;
import forestry.core.network.IStreamableGui;
import forestry.core.network.packets.PacketGuiUpdate;
import forestry.core.tiles.TileUtil;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;

public class ContainerAlveary
extends ContainerTile<TileAlveary> {
    private int beeProgress = -1;

    public static ContainerAlveary fromNetwork(int windowId, PlayerInventory inv, PacketBuffer data) {
        TileAlveary tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, data.func_179259_c(), TileAlveary.class);
        return new ContainerAlveary(windowId, inv, tile);
    }

    public ContainerAlveary(int windowid, PlayerInventory playerInv, TileAlveary tile) {
        super(windowid, ApicultureContainers.ALVEARY.containerType(), playerInv, tile, 8, 108);
        ContainerBeeHelper.addSlots(this, tile, false);
        tile.getBeekeepingLogic().clearCachedValues();
        LazyOptional<IClimateListener> listener = ClimateRoot.getInstance().getListener(tile.func_145831_w(), tile.func_174877_v());
        if (playerInv.field_70458_d instanceof ServerPlayerEntity) {
            listener.ifPresent(l -> l.syncToClient((ServerPlayerEntity)playerInv.field_70458_d));
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int beeProgress = ((TileAlveary)this.tile).getBeekeepingLogic().getBeeProgressPercent();
        if (this.beeProgress != beeProgress) {
            this.beeProgress = beeProgress;
            PacketGuiUpdate packet = new PacketGuiUpdate((IStreamableGui)this.tile);
            this.sendPacketToListeners(packet);
        }
    }
}

