/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.inventory.ItemInventoryImprinter;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticHelper;
import genetics.api.organism.IOrganism;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class GuiImprinter
extends GuiForestry<ContainerImprinter> {
    private final ItemInventoryImprinter itemInventory;
    private int startX;
    private int startY;
    private final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    public GuiImprinter(ContainerImprinter container, PlayerInventory inventoryplayer, ITextComponent title) {
        super("textures/gui/imprinter.png", container, inventoryplayer, title);
        this.itemInventory = (ItemInventoryImprinter)container.getItemInventory();
        this.field_146999_f = 176;
        this.field_147000_g = 185;
        NonNullList beeList = NonNullList.func_191196_a();
        ((ItemBeeGE)ApicultureItems.BEE_DRONE.item()).addCreativeItems((NonNullList<ItemStack>)beeList, false);
        for (ItemStack beeStack : beeList) {
            IOrganism organism = GeneticHelper.getOrganism(beeStack);
            if (organism.isEmpty()) continue;
            IAlleleBeeSpecies species = organism.getAllele(BeeChromosomes.SPECIES, true);
            this.iconStacks.put(species.getRegistryName().toString(), beeStack);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        int offset = (138 - this.getFontRenderer().func_78256_a(Translator.translateToLocal("for.gui.imprinter"))) / 2;
        this.getFontRenderer().func_238421_b_(transform, Translator.translateToLocal("for.gui.imprinter"), (float)(this.startX + 8 + offset), (float)(this.startY + 16), ColourProperties.INSTANCE.get("gui.screen"));
        IAlleleBeeSpecies primary = this.itemInventory.getPrimary();
        this.drawBeeSpeciesIcon(primary, this.startX + 12, this.startY + 32);
        this.getFontRenderer().func_238421_b_(transform, primary.getDisplayName().getString(), (float)(this.startX + 32), (float)(this.startY + 36), ColourProperties.INSTANCE.get("gui.screen"));
        IAlleleBeeSpecies secondary = this.itemInventory.getSecondary();
        this.drawBeeSpeciesIcon(secondary, this.startX + 12, this.startY + 52);
        this.getFontRenderer().func_238421_b_(transform, secondary.getDisplayName().getString(), (float)(this.startX + 32), (float)(this.startY + 56), ColourProperties.INSTANCE.get("gui.screen"));
        String youCheater = Translator.translateToLocal("for.gui.imprinter.cheater");
        offset = (138 - this.getFontRenderer().func_78256_a(youCheater)) / 2;
        this.getFontRenderer().func_238421_b_(transform, youCheater, (float)(this.startX + 8 + offset), (float)(this.startY + 76), ColourProperties.INSTANCE.get("gui.screen"));
    }

    private void drawBeeSpeciesIcon(IAlleleBeeSpecies bee, int x, int y) {
        GuiUtil.drawItemStack(this, this.iconStacks.get(bee.getRegistryName().toString()), x, y);
    }

    private static int getHabitatSlotAtPosition(double i, double j) {
        int[] xPos = new int[]{12, 12};
        int[] yPos = new int[]{32, 52};
        for (int l = 0; l < xPos.length; ++l) {
            if (!(i >= (double)xPos[l]) || !(i <= (double)(xPos[l] + 16)) || !(j >= (double)yPos[l]) || !(j <= (double)(yPos[l] + 16))) continue;
            return l;
        }
        return -1;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int k) {
        super.func_231044_a_(mouseX, mouseY, k);
        int cornerX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cornerY = (this.field_230709_l_ - this.field_147000_g) / 2;
        int slot = GuiImprinter.getHabitatSlotAtPosition(mouseX - (double)cornerX, mouseY - (double)cornerY);
        if (slot < 0) {
            return true;
        }
        if (k == 0) {
            GuiImprinter.advanceSelection(slot);
            return true;
        }
        GuiImprinter.regressSelection(slot);
        return true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.startY = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    private static void advanceSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 0);
    }

    private static void regressSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 1);
    }

    private static void sendSelectionChange(int index, int advance) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(index, advance));
    }

    @Override
    protected void addLedgers() {
    }
}

