/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemInventoryHabitatLocator
extends ItemInventory
implements IErrorSource {
    private static final short SLOT_ENERGY = 2;
    private static final short SLOT_SPECIMEN = 0;
    private static final short SLOT_ANALYZED = 1;
    private final HabitatLocatorLogic locatorLogic;

    public ItemInventoryHabitatLocator(PlayerEntity player, ItemStack itemstack) {
        super(player, 3, itemstack);
        ItemHabitatLocator habitatLocator = (ItemHabitatLocator)itemstack.func_77973_b();
        this.locatorLogic = habitatLocator.getLocatorLogic();
    }

    private static boolean isEnergy(ItemStack itemstack) {
        return ApicultureItems.HONEY_DROPS.itemEqual(itemstack) || ApicultureItems.HONEYDEW.itemEqual(itemstack);
    }

    @Override
    public void onSlotClick(int slotIndex, PlayerEntity player) {
        ItemStack analyzed;
        Optional optionalBee;
        if (!this.func_70301_a(1).func_190926_b()) {
            if (this.locatorLogic.isBiomeFound()) {
                return;
            }
        } else if (!this.func_70301_a(0).func_190926_b()) {
            if (!ItemInventoryHabitatLocator.isEnergy(this.func_70301_a(2))) {
                return;
            }
            this.func_70298_a(2, 1);
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        if ((optionalBee = BeeManager.beeRoot.create(analyzed = this.func_70301_a(1))).isPresent()) {
            IBee bee = (IBee)optionalBee.get();
            this.locatorLogic.startBiomeSearch(bee, player);
        }
    }

    public Set<ResourceLocation> getBiomesToSearch() {
        return this.locatorLogic.getTargetBiomes();
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        if (!this.func_70301_a(1).func_190926_b()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        ItemStack specimen = this.func_70301_a(0);
        if (!BeeManager.beeRoot.isMember(specimen)) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        }
        if (!ItemInventoryHabitatLocator.isEnergy(this.func_70301_a(2))) {
            errorStates.add((Object)EnumErrorCode.NO_HONEY);
        }
        return errorStates.build();
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 2) {
            return ItemInventoryHabitatLocator.isEnergy(itemStack);
        }
        if (slotIndex == 0) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
        return false;
    }
}

