/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeRoot;
import forestry.apiculture.genetics.Bee;
import forestry.core.inventory.ItemInventory;
import genetics.api.GeneticHelper;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class ItemInventoryImprinter
extends ItemInventory {
    private static final short specimenSlot = 0;
    private static final short imprintedSlot = 1;
    private int primaryIndex = 0;
    private int secondaryIndex = 0;

    public ItemInventoryImprinter(PlayerEntity player, ItemStack itemStack) {
        super(player, 2, itemStack);
    }

    public void advancePrimary() {
        this.primaryIndex = this.primaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.primaryIndex : 0;
    }

    public void advanceSecondary() {
        this.secondaryIndex = this.secondaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.secondaryIndex : 0;
    }

    public void regressPrimary() {
        this.primaryIndex = this.primaryIndex > 0 ? --this.primaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
    }

    public void regressSecondary() {
        this.secondaryIndex = this.secondaryIndex > 0 ? --this.secondaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
    }

    public IAlleleBeeSpecies getPrimary() {
        return ((IBee)BeeManager.beeRoot.getIndividualTemplates().get(this.primaryIndex)).getGenome().getActiveAllele(BeeChromosomes.SPECIES);
    }

    public IAlleleBeeSpecies getSecondary() {
        return ((IBee)BeeManager.beeRoot.getIndividualTemplates().get(this.secondaryIndex)).getGenome().getActiveAllele(BeeChromosomes.SPECIES);
    }

    public IBee getSelectedBee() {
        IBeeRoot beeRoot = BeeManager.beeRoot;
        List individualTemplates = beeRoot.getIndividualTemplates();
        Map<String, IAllele[]> genomeTemplates = beeRoot.getTemplates().getGenomeTemplates();
        IAllele[] templateActive = genomeTemplates.get(((IBee)individualTemplates.get(this.primaryIndex)).getIdentifier());
        IAllele[] templateInactive = genomeTemplates.get(((IBee)individualTemplates.get(this.secondaryIndex)).getIdentifier());
        IGenome genome = beeRoot.getKaryotype().templateAsGenome(templateActive, templateInactive);
        return new Bee(genome);
    }

    public int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    public void setPrimaryIndex(int index) {
        this.primaryIndex = index;
    }

    public void setSecondaryIndex(int index) {
        this.secondaryIndex = index;
    }

    @Override
    public void onSlotClick(int slotIndex, PlayerEntity player) {
        ItemStack specimen = this.func_70301_a(0);
        if (specimen.func_190926_b()) {
            return;
        }
        if (!BeeManager.beeRoot.isMember(specimen)) {
            return;
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            return;
        }
        IBee imprint = this.getSelectedBee();
        GeneticHelper.setIndividual(specimen, imprint);
        this.func_70299_a(1, specimen);
        this.func_70299_a(0, ItemStack.field_190927_a);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return BeeManager.beeRoot.isMember(itemStack);
    }
}

