/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimatised;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.tiles.ITitled;
import forestry.core.utils.RenderUtil;
import forestry.modules.features.FeatureBlock;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileAlveary
extends MultiblockTileEntityForestry<MultiblockLogicAlveary>
implements IBeeHousing,
IAlvearyComponent,
IOwnedTile,
IStreamableGui,
ITitled,
IClimatised {
    private final String unlocalizedTitle;

    public TileAlveary(BlockAlvearyType type) {
        super(type.getTileType().tileType(), new MultiblockLogicAlveary());
        this.unlocalizedTitle = ((FeatureBlock)ApicultureBlocks.ALVEARY.get(type)).getTranslationKey();
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockAlveary) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), ((BlockAlveary)block).getNewState(this));
        }
        this.field_145850_b.func_195593_d(this.func_174877_v(), block);
        if (this.field_145850_b.field_72995_K) {
            RenderUtil.markForUpdate(this.func_174877_v());
        }
    }

    @Override
    public void onMachineBroken() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockAlveary) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), ((BlockAlveary)block).getNewState(this));
        }
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        if (this.field_145850_b.field_72995_K) {
            BlockPos pos = this.func_174877_v();
            RenderUtil.markForUpdate(pos);
        }
        this.func_70296_d();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional superCap = super.getCapability(capability, facing);
        if (superCap.isPresent()) {
            return superCap;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((ISidedInventory)this.getInternalInventory(), facing);
                return LazyOptional.of(() -> sidedInvWrapper).cast();
            }
            InvWrapper invWrapper = new InvWrapper((IInventory)this.getInternalInventory());
            return LazyOptional.of(() -> invWrapper).cast();
        }
        if (capability == ClimateCapabilities.CLIMATE_LISTENER) {
            IClimateListener listener = ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getClimateListener();
            return LazyOptional.of(() -> listener).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public Biome getBiome() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBiome();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeModifiers();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeListeners();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory();
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeekeepingLogic();
    }

    @Override
    public Vector3d getBeeFXCoordinates() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeFXCoordinates();
    }

    @Override
    public EnumTemperature getTemperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getHumidity();
    }

    @Override
    public int getBlockLightValue() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBlockLightValue();
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().canBlockSeeTheSky();
    }

    @Override
    public boolean isRaining() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().isRaining();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getOwnerHandler();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public String getUnlocalizedTitle() {
        return this.unlocalizedTitle;
    }

    @Override
    public float getExactTemperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactHumidity();
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAlveary(windowId, player.field_71071_by, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getUnlocalizedTitle());
    }
}

