/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.villagers;

import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemHoneyComb;
import forestry.core.registration.VillagerTrade;
import forestry.modules.features.FeatureBlock;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegisterVillager {
    public static final ResourceLocation BEEKEEPER = new ResourceLocation("forestry", "beekeeper");

    @Mod.EventBusSubscriber(modid="forestry", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public void villagerTrades(VillagerTradesEvent event) {
            if (BEEKEEPER.equals((Object)event.getType().getRegistryName())) {
                ((List)event.getTrades().get(1)).add(new GiveHoneyCombForItem(ApicultureItems.BEE_COMBS.getItems(), Items.field_151015_O, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
                ((List)event.getTrades().get(1)).add(new GiveHoneyCombForItem(ApicultureItems.BEE_COMBS.getItems(), Items.field_151172_bF, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
                ((List)event.getTrades().get(1)).add(new GiveHoneyCombForItem(ApicultureItems.BEE_COMBS.getItems(), Items.field_151174_bG, new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(8, 12), 8, 2, 0.0f));
                ((List)event.getTrades().get(2)).add(new VillagerTrade.GiveItemForEmeralds(ApicultureItems.SMOKER.getItem(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 4), 8, 6));
                ((List)event.getTrades().get(2)).add(new GiveDroneForItems(ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL).func_77973_b(), new VillagerTrade.PriceInterval(2, 4), new VillagerTrade.PriceInterval(1, 1), 8, 6, 0.0f));
                ((List)event.getTrades().get(3)).add(new VillagerTrade.GiveEmeraldForItem(ApicultureItems.BEE_PRINCESS.getItem(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 1), 8, 10));
                ((List)event.getTrades().get(3)).add(new VillagerTrade.GiveItemForEmeralds(ApicultureItems.FRAME_PROVEN.getItem(), new VillagerTrade.PriceInterval(1, 2), new VillagerTrade.PriceInterval(1, 6), 8, 10));
                ((List)event.getTrades().get(3)).add(new VillagerTrade.GiveItemForLogAndEmerald(new VillagerTrade.PriceInterval(32, 64), new VillagerTrade.PriceInterval(16, 32), ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).stack().func_77973_b(), new VillagerTrade.PriceInterval(1, 1), 8, 10));
                ((List)event.getTrades().get(4)).add(new VillagerTrade.GiveItemForItemAndEmerald(ApicultureItems.BEE_PRINCESS.getItem(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(10, 64), BeeDefinition.MONASTIC.getMemberStack(EnumBeeType.DRONE).func_77973_b(), new VillagerTrade.PriceInterval(1, 1), 8, 15));
                ((List)event.getTrades().get(4)).add(new VillagerTrade.GiveItemForTwoItems(ApicultureItems.BEE_DRONE.getItem(), new VillagerTrade.PriceInterval(1, 1), Items.field_151061_bv, new VillagerTrade.PriceInterval(12, 16), BeeDefinition.ENDED.getMemberStack(EnumBeeType.DRONE).func_77973_b(), new VillagerTrade.PriceInterval(1, 1), 8, 15));
            }
        }

        private static class GiveDroneForItems
        implements VillagerTrades.ITrade {
            final int maxUses;
            final int xp;
            final float priceMult;
            public Item buying;
            public VillagerTrade.PriceInterval buyingPriceInfo;
            public VillagerTrade.PriceInterval sellingPriceInfo;

            public GiveDroneForItems(Item buying, VillagerTrade.PriceInterval buyingPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) {
                this.buying = buying;
                this.buyingPriceInfo = buyingPriceInfo;
                this.sellingPriceInfo = sellingPriceInfo;
                this.maxUses = maxUses;
                this.xp = xp;
                this.priceMult = priceMult;
            }

            @Nullable
            public MerchantOffer func_221182_a(Entity trader, Random rand) {
                BeeDefinition[] forestryMundane = new BeeDefinition[]{BeeDefinition.FOREST, BeeDefinition.MEADOWS, BeeDefinition.MODEST, BeeDefinition.WINTRY, BeeDefinition.TROPICAL, BeeDefinition.MARSHY};
                ItemStack randomHiveDrone = forestryMundane[rand.nextInt(forestryMundane.length)].getMemberStack(EnumBeeType.DRONE);
                randomHiveDrone.func_190920_e(this.sellingPriceInfo.getPrice(rand));
                return new MerchantOffer(new ItemStack((IItemProvider)this.buying, this.buyingPriceInfo.getPrice(rand)), randomHiveDrone, this.maxUses, this.xp, this.priceMult);
            }
        }

        private static class GiveHoneyCombForItem
        implements VillagerTrades.ITrade {
            final int maxUses;
            final int xp;
            final float priceMult;
            public Collection<ItemHoneyComb> itemHoneyCombs;
            public Item buying;
            public VillagerTrade.PriceInterval sellingPriceInfo;
            public VillagerTrade.PriceInterval buyingPriceInfo;

            public GiveHoneyCombForItem(Collection<ItemHoneyComb> selling, Item buying, VillagerTrade.PriceInterval sellingPriceInfo, VillagerTrade.PriceInterval buyingPriceInfo, int maxUses, int xp, float priceMult) {
                this.itemHoneyCombs = selling;
                this.buying = buying;
                this.sellingPriceInfo = sellingPriceInfo;
                this.buyingPriceInfo = buyingPriceInfo;
                this.maxUses = maxUses;
                this.xp = xp;
                this.priceMult = priceMult;
            }

            @Nullable
            public MerchantOffer func_221182_a(Entity trader, Random rand) {
                return new MerchantOffer(new ItemStack((IItemProvider)this.buying, this.buyingPriceInfo.getPrice(rand)), new ItemStack((IItemProvider)this.itemHoneyCombs.stream().skip((int)((double)this.itemHoneyCombs.size() * Math.random())).findFirst().get(), this.sellingPriceInfo.getPrice(rand)), this.maxUses, this.xp, this.priceMult);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="forestry", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PointOfInterestType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"forestry");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"forestry");
    }
}

