/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.apiculture.HiveConfig;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.modules.features.FeatureBlock;
import genetics.api.individual.IGenome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;

public enum HiveDescription implements IHiveDescription
{
    FOREST(IHiveRegistry.HiveType.FOREST, 3.0f, BeeDefinition.FOREST, HiveManager.genHelper.tree()){

        @Override
        public void postGen(ISeedReader world, Random rand, BlockPos pos) {
            super.postGen(world, rand, pos);
            1.postGenFlowers(world, rand, pos, flowerStates);
        }
    }
    ,
    MEADOWS(IHiveRegistry.HiveType.MEADOWS, 1.0f, BeeDefinition.MEADOWS, HiveManager.genHelper.ground(Blocks.field_150346_d, Blocks.field_196658_i)){

        @Override
        public void postGen(ISeedReader world, Random rand, BlockPos pos) {
            super.postGen(world, rand, pos);
            2.postGenFlowers(world, rand, pos, flowerStates);
        }
    }
    ,
    DESERT(IHiveRegistry.HiveType.DESERT, 1.0f, BeeDefinition.MODEST, HiveManager.genHelper.ground(Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_150354_m, Blocks.field_150322_A)){

        @Override
        public void postGen(ISeedReader world, Random rand, BlockPos pos) {
            super.postGen(world, rand, pos);
            3.postGenFlowers(world, rand, pos, cactusStates);
        }
    }
    ,
    JUNGLE(IHiveRegistry.HiveType.JUNGLE, 6.0f, BeeDefinition.TROPICAL, HiveManager.genHelper.tree()),
    END(IHiveRegistry.HiveType.END, 2.0f, BeeDefinition.ENDED, HiveManager.genHelper.ground(Blocks.field_150377_bs, Blocks.field_196806_hJ)){

        @Override
        public boolean isGoodBiome(Biome biome) {
            return biome.func_201856_r() == Biome.Category.THEEND;
        }
    }
    ,
    SNOW(IHiveRegistry.HiveType.SNOW, 2.0f, BeeDefinition.WINTRY, HiveManager.genHelper.ground(Blocks.field_150346_d, Blocks.field_150433_aE, Blocks.field_196658_i)){

        @Override
        public void postGen(ISeedReader world, Random rand, BlockPos pos) {
            BlockPos posAbove = pos.func_177984_a();
            if (world.func_175623_d(posAbove)) {
                world.func_180501_a(posAbove, Blocks.field_150433_aE.func_176223_P(), 2);
            }
            5.postGenFlowers(world, rand, pos, flowerStates);
        }
    }
    ,
    SWAMP(IHiveRegistry.HiveType.SWAMP, 2.0f, BeeDefinition.MARSHY, HiveManager.genHelper.ground(Blocks.field_150346_d, Blocks.field_196658_i)){

        @Override
        public void postGen(ISeedReader world, Random rand, BlockPos pos) {
            super.postGen(world, rand, pos);
            6.postGenFlowers(world, rand, pos, mushroomStates);
        }
    };

    private static final IHiveGen groundGen;
    private static final List<BlockState> flowerStates;
    private static final List<BlockState> mushroomStates;
    private static final List<BlockState> cactusStates;
    private final BlockState blockState;
    private final float genChance;
    private final IGenome beeGenome;
    private final IHiveGen hiveGen;
    private final IHiveRegistry.HiveType hiveType;

    private HiveDescription(IHiveRegistry.HiveType hiveType, float genChance, BeeDefinition beeTemplate, IHiveGen hiveGen) {
        this.blockState = ((FeatureBlock)ApicultureBlocks.BEEHIVE.get(hiveType)).defaultState();
        this.genChance = genChance;
        this.beeGenome = beeTemplate.getGenome();
        this.hiveGen = hiveGen;
        this.hiveType = hiveType;
    }

    @Override
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public boolean isGoodBiome(Biome biome) {
        return !BiomeHelper.isBiomeHellish(biome) && !HiveConfig.isBlacklisted(this.hiveType, biome);
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        EnumHumidity idealHumidity = this.beeGenome.getActiveAllele(BeeChromosomes.SPECIES).getHumidity();
        EnumTolerance humidityTolerance = this.beeGenome.getActiveValue(BeeChromosomes.HUMIDITY_TOLERANCE);
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        EnumTemperature idealTemperature = this.beeGenome.getActiveAllele(BeeChromosomes.SPECIES).getTemperature();
        EnumTolerance temperatureTolerance = this.beeGenome.getActiveValue(BeeChromosomes.TEMPERATURE_TOLERANCE);
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    @Override
    public float getGenChance() {
        return this.genChance;
    }

    @Override
    public void postGen(ISeedReader world, Random rand, BlockPos pos) {
    }

    protected static void postGenFlowers(ISeedReader world, Random rand, BlockPos hivePos, List<BlockState> flowerStates) {
        int plantedCount = 0;
        for (int i = 0; i < 10; ++i) {
            BlockState state;
            Block block;
            int xOffset = rand.nextInt(8) - 4;
            int zOffset = rand.nextInt(8) - 4;
            BlockPos blockPos = hivePos.func_177982_a(xOffset, 0, zOffset);
            if (xOffset == 0 && zOffset == 0 || !world.func_175667_e(blockPos) || (blockPos = groundGen.getPosForHive(world, blockPos.func_177958_n(), blockPos.func_177952_p())) == null || !(block = (state = flowerStates.get(rand.nextInt(flowerStates.size()))).func_177230_c()).func_176223_P().func_196955_c((IWorldReader)world, blockPos)) continue;
            world.func_180501_a(blockPos, state, 2);
            if (++plantedCount >= 3) break;
        }
    }

    static {
        groundGen = HiveManager.genHelper.ground(Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150322_A);
        flowerStates = new ArrayList<BlockState>();
        mushroomStates = new ArrayList<BlockState>();
        cactusStates = Collections.singletonList(Blocks.field_150434_aF.func_176223_P());
        flowerStates.addAll((Collection<BlockState>)Blocks.field_196606_bd.func_176194_O().func_177619_a());
        flowerStates.addAll((Collection<BlockState>)Blocks.field_196605_bc.func_176194_O().func_177619_a());
        mushroomStates.add(Blocks.field_150337_Q.func_176223_P());
        mushroomStates.add(Blocks.field_150338_P.func_176223_P());
    }
}

