/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.tiles.TileHive;
import forestry.apiculture.worldgen.HiveGenGround;
import forestry.core.tiles.TileUtil;
import forestry.modules.features.FeatureBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;

public class HiveDescriptionSwarmer
implements IHiveDescription {
    private final List<ItemStack> bees;

    public HiveDescriptionSwarmer(ItemStack ... bees) {
        this.bees = Arrays.asList(bees);
    }

    @Override
    public IHiveGen getHiveGen() {
        return new HiveGenGround(Blocks.field_150346_d, Blocks.field_150349_c);
    }

    @Override
    public BlockState getBlockState() {
        return ((FeatureBlock)ApicultureBlocks.BEEHIVE.get(IHiveRegistry.HiveType.SWARM)).defaultState();
    }

    @Override
    public boolean isGoodBiome(Biome biome) {
        return true;
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        return true;
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        return true;
    }

    @Override
    public float getGenChance() {
        return 128.0f;
    }

    @Override
    public void postGen(ISeedReader world, Random rand, BlockPos pos) {
        TileUtil.actOnTile((IWorldReader)world, pos, TileHive.class, tile -> tile.setContained(this.bees));
    }
}

