/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.filter.IFilterData;
import forestry.api.genetics.filter.IFilterRule;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.render.TextureManagerForestry;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ArboricultureFilterRuleType implements IFilterRuleType
{
    TREE{

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return data.isPresent();
        }
    }
    ,
    SAPLING{

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return data.isPresent() && data.getType() == EnumGermlingType.SAPLING;
        }
    }
    ,
    POLLEN{

        @Override
        public boolean isValid(ItemStack itemStack, IFilterData data) {
            return data.isPresent() && data.getType() == EnumGermlingType.POLLEN;
        }
    };

    private final String uid = "forestry.arboriculture." + this.name().toLowerCase(Locale.ENGLISH);

    public static void init() {
        for (ArboricultureFilterRuleType rule : ArboricultureFilterRuleType.values()) {
            AlleleManager.filterRegistry.registerFilter(rule);
        }
    }

    @Override
    public void addLogic(IFilterRule logic) {
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite() {
        return TextureManagerForestry.getInstance().getDefault("analyzer/" + this.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureMap() {
        return TextureManagerForestry.LOCATION_FORESTRY_TEXTURE;
    }

    @Override
    public String getRootUID() {
        return TreeManager.treeRoot.getUID();
    }

    @Override
    public String getUID() {
        return this.uid;
    }
}

