/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import forestry.arboriculture.FruitProviderNone;
import forestry.core.data.ForestryTags;
import forestry.core.genetics.ProductListWrapper;
import forestry.core.utils.BlockUtil;
import genetics.api.individual.IGenome;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public class FruitProviderPod
extends FruitProviderNone {
    private final EnumPodType type;
    private ProductListWrapper products;

    public FruitProviderPod(String unlocalizedDescription, IFruitFamily family, EnumPodType type, Supplier<ItemStack> dropOnMature) {
        super(unlocalizedDescription, family);
        this.type = type;
        this.products = ProductListWrapper.create();
        this.products.addProduct(dropOnMature, 1.0f);
    }

    @Override
    public void onStartSetup() {
        this.products = this.products.bake();
    }

    @Override
    public boolean requiresFruitBlocks() {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getFruits(@Nullable IGenome genome, World world, BlockPos pos, int ripeningTime) {
        if (ripeningTime >= 2) {
            return this.products.getPossibleStacks();
        }
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean trySpawnFruitBlock(IGenome genome, IWorld world, Random rand, BlockPos pos) {
        if (rand.nextFloat() > this.getFruitChance(genome, world, pos)) {
            return false;
        }
        if (this.type == EnumPodType.COCOA) {
            return BlockUtil.tryPlantCocoaPod(world, pos);
        }
        IAlleleFruit activeAllele = genome.getActiveAllele(TreeChromosomes.FRUITS);
        return TreeManager.treeRoot.setFruitBlock(world, genome, activeAllele, genome.getActiveValue(TreeChromosomes.YIELD).floatValue(), pos);
    }

    @Override
    public ResourceLocation getSprite(IGenome genome, IBlockReader world, BlockPos pos, int ripeningTime) {
        return null;
    }

    @Override
    public ResourceLocation getDecorativeSprite() {
        return null;
    }

    @Override
    public IProductList getProducts() {
        return this.products;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
    }

    @Override
    public String getModelName() {
        return this.type.getModelName();
    }

    @Override
    public ITag<Block> getLogTag() {
        switch (this.type) {
            case DATES: {
                return ForestryTags.Blocks.PALM_LOGS;
            }
            case PAPAYA: {
                return ForestryTags.Blocks.PAPAYA_LOGS;
            }
        }
        return BlockTags.field_203289_r;
    }

    public static enum EnumPodType {
        COCOA,
        DATES,
        PAPAYA;


        public String getModelName() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

