/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IArmorNaturalist;
import forestry.api.modules.ForestryModule;
import forestry.arboriculture.ArboricultureFilterRuleType;
import forestry.arboriculture.TreeConfig;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.capabilities.ArmorNaturalist;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.features.ArboricultureFeatures;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeFactory;
import forestry.arboriculture.genetics.TreeMutationFactory;
import forestry.arboriculture.network.PacketRegistryArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.proxy.ProxyArboricultureClient;
import forestry.arboriculture.villagers.RegisterVillager;
import forestry.core.ModuleCore;
import forestry.core.capabilities.NullStorage;
import forestry.core.config.Config;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.ForgeUtils;
import forestry.modules.BlankForestryModule;
import forestry.modules.ISidedModuleHandler;
import forestry.modules.ModuleHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@ForestryModule(containerID="forestry", moduleID="arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.arboriculture.description", lootTable="arboriculture")
public class ModuleArboriculture
extends BlankForestryModule {
    private static final String CONFIG_CATEGORY = "arboriculture";
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static final List<Block> validFences;
    @Nullable
    public static VillagerProfession villagerArborist;

    public ModuleArboriculture() {
        proxy = (ProxyArboriculture)DistExecutor.safeRunForDist(() -> ProxyArboricultureClient::new, () -> ProxyArboriculture::new);
        ForgeUtils.registerSubscriber(this);
        if (Config.enableVillagers) {
            RegisterVillager.Registers.POINTS_OF_INTEREST.register(FMLJavaModLoadingContext.get().getModEventBus());
            RegisterVillager.Registers.PROFESSIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
            MinecraftForge.EVENT_BUS.register((Object)new RegisterVillager.Events());
        }
        if (TreeConfig.getSpawnRarity(null) > 0.0f) {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addGenericListener(Feature.class, ArboricultureFeatures::registerFeatures);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ArboricultureFeatures::onBiomeLoad);
        }
    }

    @Override
    public void setupAPI() {
        TreeManager.treeFactory = new TreeFactory();
        TreeManager.treeMutationFactory = new TreeMutationFactory();
        TreeManager.woodAccess = WoodAccess.getInstance();
    }

    @Override
    public void disabledSetupAPI() {
        TreeManager.woodAccess = WoodAccess.getInstance();
    }

    @Override
    public void preInit() {
        CapabilityManager.INSTANCE.register(IArmorNaturalist.class, new NullStorage(), () -> ArmorNaturalist.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (TreeConfig.getSpawnRarity(null) > 0.0f) {
            // empty if block
        }
        proxy.initializeModels();
        ModuleCore.rootCommand.then(CommandTree.register());
        if (ModuleHelper.isEnabled("sorting")) {
            ArboricultureFilterRuleType.init();
        }
    }

    @Override
    public void doInit() {
        boolean deleted;
        File configFile;
        LocalizedConfiguration config;
        TreeDefinition.initTrees();
        if (Config.enableVillagers) {
            // empty if block
        }
        if (!Objects.equals((config = new LocalizedConfiguration(configFile = new File(Forestry.instance.getConfigFolder(), "arboriculture.cfg"), "1.0.0")).getLoadedConfigVersion(), config.getDefinedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "1.0.0");
        }
        TreeConfig.parse(config);
        config.save();
    }

    @Override
    public void registerRecipes() {
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryArboriculture();
    }

    @Override
    public boolean processIMCMessage(InterModComms.IMCMessage message) {
        return false;
    }

    @Override
    public ISidedModuleHandler getModuleHandler() {
        return proxy;
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
    }
}

