/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.ForestryComponentKeys;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import forestry.apiculture.DisplayHelper;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeDisplayHandler;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.genetics.alleles.AlleleLeafEffects;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.root.ResearchHandler;
import forestry.modules.features.FeatureBlock;
import genetics.api.GeneticPlugin;
import genetics.api.GeneticsAPI;
import genetics.api.IGeneticApiInstance;
import genetics.api.IGeneticFactory;
import genetics.api.IGeneticPlugin;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.classification.IClassificationRegistry;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IGeneticListenerRegistry;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IRootDefinition;
import genetics.api.root.IRootManager;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.translator.IBlockTranslator;
import genetics.api.root.translator.IItemTranslator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;

@GeneticPlugin(modId="forestry")
public class TreePlugin
implements IGeneticPlugin {
    public static final IRootDefinition<TreeRoot> ROOT = GeneticsAPI.apiInstance.getRoot("rootTrees");

    @Override
    public void registerClassifications(IClassificationRegistry registry) {
        TreeBranchDefinition.registerBranches(registry);
    }

    @Override
    public void registerListeners(IGeneticListenerRegistry registry) {
        registry.add("rootTrees", TreeDefinition.VALUES);
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAlleles(EnumAllele.Height.values(), TreeChromosomes.HEIGHT);
        registry.registerAlleles(EnumAllele.Saplings.values(), TreeChromosomes.FERTILITY);
        registry.registerAlleles(EnumAllele.Yield.values(), TreeChromosomes.YIELD);
        registry.registerAlleles(EnumAllele.Fireproof.values(), TreeChromosomes.FIREPROOF);
        registry.registerAlleles(EnumAllele.Maturation.values(), TreeChromosomes.MATURATION);
        registry.registerAlleles(EnumAllele.Sappiness.values(), TreeChromosomes.SAPPINESS);
        AlleleFruits.registerAlleles(registry);
        AlleleLeafEffects.registerAlleles(registry);
    }

    @Override
    public void createRoot(IRootManager rootManager, IGeneticFactory geneticFactory) {
        IIndividualRootBuilder rootBuilder = rootManager.createRoot("rootTrees");
        rootBuilder.setRootFactory(TreeRoot::new).setSpeciesType(TreeChromosomes.SPECIES).addListener(ComponentKeys.TYPES, builder -> {
            builder.registerType((IOrganismType)EnumGermlingType.SAPLING, ArboricultureItems.SAPLING::stack);
            builder.registerType((IOrganismType)EnumGermlingType.POLLEN, ArboricultureItems.POLLEN_FERTILE::stack);
        }).addComponent(ComponentKeys.TRANSLATORS).addComponent(ComponentKeys.MUTATIONS).addComponent(ForestryComponentKeys.RESEARCH, ResearchHandler::new).addListener(ForestryComponentKeys.RESEARCH, builder -> {
            builder.setResearchSuitability(new ItemStack((IItemProvider)Blocks.field_196674_t), 1.0f);
            builder.addPlugin((species, itemstack) -> {
                if (itemstack.func_190926_b() || !(species instanceof IAlleleTreeSpecies)) {
                    return -1.0f;
                }
                IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies)species;
                Collection<IFruitFamily> suitableFruit = treeSpecies.getSuitableFruit();
                for (IFruitFamily fruitFamily : suitableFruit) {
                    Collection<IFruitProvider> fruitProviders = TreeManager.treeRoot.getFruitProvidersForFruitFamily(fruitFamily);
                    for (IFruitProvider fruitProvider : fruitProviders) {
                        IProductList products = fruitProvider.getProducts();
                        for (ItemStack stack : products.getPossibleStacks()) {
                            if (!stack.func_77969_a(itemstack)) continue;
                            return 1.0f;
                        }
                        IProductList specialtyChances = fruitProvider.getSpecialty();
                        for (ItemStack stack : specialtyChances.getPossibleStacks()) {
                            if (!stack.func_77969_a(itemstack)) continue;
                            return 1.0f;
                        }
                    }
                }
                return -1.0f;
            });
        }).addListener(ComponentKeys.TRANSLATORS, builder -> {
            Function<TreeDefinition, IBlockTranslator> leavesFactory = definition -> blockState -> {
                if (((Boolean)blockState.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue()) {
                    return null;
                }
                return definition.createIndividual();
            };
            Function<TreeDefinition, IItemTranslator> saplingFactory = definition -> new IItemTranslator<ITree>(){

                @Override
                public ITree getIndividualFromObject(ItemStack itemStack) {
                    return definition.createIndividual();
                }

                @Override
                public ItemStack getGeneticEquivalent(ItemStack itemStack) {
                    return definition.getMemberStack(EnumGermlingType.SAPLING);
                }
            };
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.Oak), Blocks.field_196642_W);
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.Birch), Blocks.field_196647_Y);
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.Spruce), Blocks.field_196645_X);
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.Jungle), Blocks.field_196648_Z);
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.Acacia), Blocks.field_196572_aa);
            builder.registerTranslator(leavesFactory.apply(TreeDefinition.DarkOak), Blocks.field_196574_ab);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.Oak), Items.field_221592_t);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.Birch), Items.field_221638_ag);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.Spruce), Items.field_221636_af);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.Jungle), Items.field_221640_ah);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.Acacia), Items.field_221642_ai);
            builder.registerTranslator(saplingFactory.apply(TreeDefinition.DarkOak), Items.field_221644_aj);
            for (Map.Entry leaves : ArboricultureBlocks.LEAVES_DEFAULT.getFeatureByType().entrySet()) {
                builder.registerTranslator(blockState -> ((TreeDefinition)leaves.getKey()).createIndividual(), new Block[]{((FeatureBlock)leaves.getValue()).block()});
            }
            for (Map.Entry leaves : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getFeatureByType().entrySet()) {
                builder.registerTranslator(blockState -> ((TreeDefinition)leaves.getKey()).createIndividual(), new Block[]{((FeatureBlock)leaves.getValue()).block()});
            }
        }).setDefaultTemplate(TreeHelper::createDefaultTemplate);
    }

    @Override
    public void onFinishRegistration(IRootManager manager, IGeneticApiInstance instance) {
        TreeManager.treeRoot = TreeManager.treeRootDefinition.get();
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.insane);
        TreeDisplayHandler.init(DisplayHelper.getInstance());
    }
}

