/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.WorldUtils;
import forestry.core.worldgen.FeatureBase;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.commands.SpeciesNotFoundException;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public final class TreeGenHelper {
    public static Feature<NoFeatureConfig> getWorldGen(ResourceLocation treeName, PlayerEntity player, BlockPos pos) throws SpeciesNotFoundException {
        IGenome treeGenome = TreeGenHelper.getTreeGenome(treeName);
        ITree tree = TreeManager.treeRoot.getTree(player.field_70170_p, treeGenome);
        return tree.getTreeGenerator((ISeedReader)WorldUtils.asServer((IWorld)player.field_70170_p), pos, true);
    }

    public static <FC extends IFeatureConfig> boolean generateTree(Feature<FC> feature, ChunkGenerator generator, World world, BlockPos pos, FC config) {
        if ((pos = pos.func_177956_o() > 0 && world.func_175623_d(pos.func_177977_b()) ? BlockUtil.getNextSolidDownPos(world, pos) : BlockUtil.getNextReplaceableUpPos(world, pos)) == null) {
            return false;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canPlaceTree(blockState, (IWorld)world, pos)) {
            if (feature instanceof FeatureBase) {
                return ((FeatureBase)feature).place((IWorld)world, world.field_73012_v, pos, true);
            }
            return feature.func_241855_a((ISeedReader)((ServerWorld)world), generator, world.field_73012_v, pos, config);
        }
        return false;
    }

    public static boolean generateTree(ITree tree, ISeedReader world, BlockPos pos) {
        Feature<NoFeatureConfig> gen = tree.getTreeGenerator(world, pos, true);
        BlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canPlaceTree(blockState, (IWorld)world, pos)) {
            if (gen instanceof FeatureBase) {
                return ((FeatureBase)gen).place((IWorld)world, world.func_201674_k(), pos, true);
            }
            return gen.func_241855_a((ISeedReader)((ServerWorld)world), ((ServerChunkProvider)world.func_72863_F()).func_201711_g(), world.func_201674_k(), pos, (IFeatureConfig)IFeatureConfig.field_202429_e);
        }
        return false;
    }

    private static IGenome getTreeGenome(ResourceLocation speciesName) throws SpeciesNotFoundException {
        IAllele species = null;
        for (ResourceLocation uid : AlleleUtils.getRegisteredNames()) {
            IAllele allele2;
            Optional optionalAllele;
            if (!uid.equals((Object)speciesName) || !(optionalAllele = AlleleUtils.getAllele(uid)).isPresent() || !((allele2 = (IAllele)optionalAllele.get()) instanceof IAlleleTreeSpecies)) continue;
            species = (IAlleleTreeSpecies)allele2;
            break;
        }
        if (species == null) {
            species = AlleleUtils.filteredStream(TreeChromosomes.SPECIES).filter(allele -> {
                String displayName = allele.getDisplayName().getString().replaceAll("\\s", "");
                return displayName.equals(speciesName.toString());
            }).findFirst().orElse(null);
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = TreeManager.treeRoot.getTemplates().getTemplate(species.getRegistryName().toString());
        return TreeManager.treeRoot.getKaryotype().templateAsGenome(template);
    }
}

