/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.features;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.core.IBlockSubtype;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockArboriculture;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.blocks.BlockForestryDoor;
import forestry.arboriculture.blocks.BlockForestryFence;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.blocks.BlockForestryLog;
import forestry.arboriculture.blocks.BlockForestryPlank;
import forestry.arboriculture.blocks.BlockForestrySlab;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.blocks.BlockTypeArboricultureTesr;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.items.ItemBlockDecorativeLeaves;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.items.ItemBlockWoodDoor;
import forestry.arboriculture.items.ItemBlockWoodSlab;
import forestry.core.items.ItemBlockBase;
import forestry.core.items.ItemBlockForestry;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureGroup;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;

@FeatureProvider
public class ArboricultureBlocks {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get(ModuleArboriculture.class);
    public static final FeatureBlockGroup<BlockForestryLog, EnumForestryWoodType> LOGS = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, EnumForestryWoodType> LOGS_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryLog, EnumVanillaWoodType> LOGS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryLog::new, (WoodBlockKind)WoodBlockKind.LOG, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, EnumForestryWoodType> PLANKS = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, EnumForestryWoodType> PLANKS_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryPlank, EnumVanillaWoodType> PLANKS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryPlank::new, (WoodBlockKind)WoodBlockKind.PLANKS, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, EnumForestryWoodType> SLABS = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS.get((EnumForestryWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, EnumForestryWoodType> SLABS_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS_FIREPROOF.get((EnumForestryWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestrySlab, EnumVanillaWoodType> SLABS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestrySlab((BlockForestryPlank)((FeatureBlock)PLANKS_VANILLA_FIREPROOF.get((EnumVanillaWoodType)type)).block()), ItemBlockWoodSlab::new, (WoodBlockKind)WoodBlockKind.SLAB, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, EnumForestryWoodType> FENCES = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, EnumForestryWoodType> FENCES_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFence, EnumVanillaWoodType> FENCES_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFence::new, (WoodBlockKind)WoodBlockKind.FENCE, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, EnumForestryWoodType> FENCE_GATES = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, EnumForestryWoodType> FENCE_GATES_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryFenceGate, EnumVanillaWoodType> FENCE_GATES_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup(BlockForestryFenceGate::new, (WoodBlockKind)WoodBlockKind.FENCE_GATE, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, EnumForestryWoodType> STAIRS = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS.get((EnumForestryWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, EnumForestryWoodType> STAIRS_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS_FIREPROOF.get((EnumForestryWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)true, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryStairs, EnumVanillaWoodType> STAIRS_VANILLA_FIREPROOF = ArboricultureBlocks.woodGroup((T type) -> new BlockForestryStairs((BlockForestryPlank)((FeatureBlock)PLANKS_VANILLA_FIREPROOF.get((EnumVanillaWoodType)type)).block()), (WoodBlockKind)WoodBlockKind.STAIRS, (boolean)true, (IWoodType[])EnumVanillaWoodType.VALUES);
    public static final FeatureBlockGroup<BlockForestryDoor, EnumForestryWoodType> DOORS = ArboricultureBlocks.woodGroup(BlockForestryDoor::new, ItemBlockWoodDoor::new, (WoodBlockKind)WoodBlockKind.DOOR, (boolean)false, (IWoodType[])EnumForestryWoodType.VALUES);
    public static final FeatureBlock<BlockSapling, BlockItem> SAPLING_GE = REGISTRY.block(BlockSapling::new, ItemBlockForestry::new, "sapling_ge");
    public static final FeatureBlock<BlockForestryLeaves, ItemBlockLeaves> LEAVES = REGISTRY.block(BlockForestryLeaves::new, ItemBlockLeaves::new, "leaves");
    public static final FeatureBlockGroup<BlockDefaultLeaves, TreeDefinition> LEAVES_DEFAULT = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDefaultLeaves::new, TreeDefinition.VALUES).item(ItemBlockLeaves::new).identifier("default_leaves", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockDefaultLeavesFruit, TreeDefinition> LEAVES_DEFAULT_FRUIT = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDefaultLeavesFruit::new, TreeDefinition.VALUES).item(ItemBlockLeaves::new).identifier("default_leaves_fruit", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockDecorativeLeaves, TreeDefinition> LEAVES_DECORATIVE = (FeatureBlockGroup)REGISTRY.blockGroup(BlockDecorativeLeaves::new, TreeDefinition.VALUES).item(ItemBlockDecorativeLeaves::new).identifier("decorative_leaves", FeatureGroup.IdentifierType.AFFIX).create();
    public static final FeatureBlockGroup<BlockFruitPod, IAlleleFruit> PODS = (FeatureBlockGroup)REGISTRY.blockGroup(BlockFruitPod::new, AlleleFruits.getFruitAllelesWithModels()).identifier("pods").create();
    public static final FeatureBlock<BlockArboriculture, ItemBlockBase> TREE_CHEST = REGISTRY.block(() -> new BlockArboriculture(BlockTypeArboricultureTesr.ARB_CHEST), block -> new ItemBlockBase<BlockArboriculture>((BlockArboriculture)block, BlockTypeArboricultureTesr.ARB_CHEST), "tree_chest");

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(BiFunction<Boolean, S, B> constructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.woodGroup(constructor, (T x$0) -> new ItemBlockWood<Block>((Block)x$0), (WoodBlockKind)kind, (boolean)fireproof, types);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(BiFunction<Boolean, S, B> constructor, Function<B, BlockItem> itemConstructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.registerWood((FeatureBlockGroup)REGISTRY.blockGroup(type -> (Block)constructor.apply(fireproof, type), (IBlockSubtype[])types).item(itemConstructor).identifier((fireproof ? "fireproof_" : "") + kind.func_176610_l(), FeatureGroup.IdentifierType.AFFIX).create(), kind);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(Function<S, B> constructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.woodGroup(constructor, (T x$0) -> new ItemBlockWood<Block>((Block)x$0), (WoodBlockKind)kind, (boolean)fireproof, types);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> woodGroup(Function<S, B> constructor, Function<B, BlockItem> itemConstructor, WoodBlockKind kind, boolean fireproof, S[] types) {
        return ArboricultureBlocks.registerWood((FeatureBlockGroup)REGISTRY.blockGroup(constructor, (IBlockSubtype[])types).item(itemConstructor).identifier((fireproof ? "fireproof_" : "") + kind.func_176610_l(), FeatureGroup.IdentifierType.AFFIX).create(), kind);
    }

    private static <B extends Block, S extends IWoodType> FeatureBlockGroup<B, S> registerWood(FeatureBlockGroup<B, S> group, WoodBlockKind kind) {
        REGISTRY.addRegistryListener(FeatureType.ITEM, event -> WoodAccess.getInstance().registerFeatures(group, kind));
        return group;
    }

    private ArboricultureBlocks() {
    }
}

