/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.core.config.Config;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticHelper;
import genetics.api.individual.IGenome;
import genetics.api.organism.IOrganism;
import genetics.api.organism.IOrganismType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TreeAlyzerPlugin
implements IAlyzerPlugin {
    public static final TreeAlyzerPlugin INSTANCE = new TreeAlyzerPlugin();
    protected final Map<ResourceLocation, ItemStack> iconStacks = new HashMap<ResourceLocation, ItemStack>();

    private TreeAlyzerPlugin() {
        NonNullList treeList = NonNullList.func_191196_a();
        ((ItemGermlingGE)ArboricultureItems.SAPLING.item()).addCreativeItems((NonNullList<ItemStack>)treeList, false);
        for (ItemStack treeStack : treeList) {
            IOrganism organism = GeneticHelper.getOrganism(treeStack);
            if (organism.isEmpty()) continue;
            IAlleleTreeSpecies species = organism.getAllele(TreeChromosomes.SPECIES, true);
            this.iconStacks.put(species.getRegistryName(), treeStack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage1(MatrixStack transform, Screen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = TreeManager.treeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            ITree tree = (ITree)optional.get();
            Optional<IOrganismType> typeOptional = TreeManager.treeRoot.getTypes().getType(itemStack);
            if (!typeOptional.isPresent()) {
                return;
            }
            IOrganismType type = typeOptional.get();
            IGenome genome = tree.getGenome();
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            guiAlyzer.drawSpeciesRow(transform, Translator.translateToLocal("for.gui.species"), tree, TreeChromosomes.SPECIES, type);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.saplings"), tree, TreeChromosomes.FERTILITY);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.maturity"), tree, TreeChromosomes.MATURATION);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.height"), tree, TreeChromosomes.HEIGHT);
            textLayout.newLineCompressed();
            int activeGirth = genome.getActiveValue(TreeChromosomes.GIRTH);
            int inactiveGirth = genome.getInactiveValue(TreeChromosomes.GIRTH);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.girth"), 12);
            guiAlyzer.drawLine(transform, String.format("%sx%s", activeGirth, activeGirth), 90, tree, TreeChromosomes.GIRTH, false);
            guiAlyzer.drawLine(transform, String.format("%sx%s", inactiveGirth, inactiveGirth), 155, tree, TreeChromosomes.GIRTH, true);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.yield"), tree, TreeChromosomes.YIELD);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.sappiness"), tree, TreeChromosomes.SAPPINESS);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.effect"), tree, TreeChromosomes.EFFECT);
            textLayout.endPage();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage2(MatrixStack transform, Screen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = TreeManager.treeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            ITree tree = (ITree)optional.get();
            IGenome genome = tree.getGenome();
            IAlleleTreeSpecies primary = genome.getActiveAllele(TreeChromosomes.SPECIES);
            IAlleleTreeSpecies secondary = genome.getInactiveAllele(TreeChromosomes.SPECIES);
            IAlleleFruit activeFruit = tree.getGenome().getActiveAllele(TreeChromosomes.FRUITS);
            IAlleleFruit inactiveFruit = tree.getGenome().getInactiveAllele(TreeChromosomes.FRUITS);
            IFruitFamily primaryFamily = activeFruit.getProvider().getFamily();
            IFruitFamily secondaryFamily = inactiveFruit.getProvider().getFamily();
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            int speciesDominance0 = guiAlyzer.getColorCoding(primary.isDominant());
            int speciesDominance1 = guiAlyzer.getColorCoding(genome.getSecondary().isDominant());
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            String yes = Translator.translateToLocal("for.yes");
            String no = Translator.translateToLocal("for.no");
            String fireproofActive = StringUtil.readableBoolean(genome.getActiveValue(TreeChromosomes.FIREPROOF), yes, no);
            String fireproofInactive = StringUtil.readableBoolean(genome.getInactiveValue(TreeChromosomes.FIREPROOF), yes, no);
            guiAlyzer.drawRow(transform, Translator.translateToLocal("for.gui.fireproof"), fireproofActive, fireproofInactive, tree, TreeChromosomes.FIREPROOF);
            textLayout.newLine();
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.native"), 12);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui." + primary.getPlantType().getName()), 90, speciesDominance0);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui." + secondary.getPlantType().getName()), 155, speciesDominance1);
            textLayout.newLine();
            textLayout.drawTranslatedLine(transform, "for.gui.supports", 12);
            ArrayList<IFruitFamily> families0 = new ArrayList<IFruitFamily>(primary.getSuitableFruit());
            ArrayList<IFruitFamily> families1 = new ArrayList<IFruitFamily>(secondary.getSuitableFruit());
            int max = Math.max(families0.size(), families1.size());
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    textLayout.newLineCompressed();
                }
                if (families0.size() > i) {
                    textLayout.drawLine(transform, (ITextComponent)((IFruitFamily)families0.get(i)).getName(), 90, speciesDominance0);
                }
                if (families1.size() <= i) continue;
                textLayout.drawLine(transform, (ITextComponent)((IFruitFamily)families1.get(i)).getName(), 155, speciesDominance1);
            }
            textLayout.newLine();
            int fruitDominance0 = guiAlyzer.getColorCoding(activeFruit.isDominant());
            int fruitDominance1 = guiAlyzer.getColorCoding(inactiveFruit.isDominant());
            textLayout.drawTranslatedLine(transform, "for.gui.fruits", 12);
            TextFormatting strike = TextFormatting.RESET;
            if (!tree.canBearFruit() && activeFruit != AlleleFruits.fruitNone) {
                strike = TextFormatting.STRIKETHROUGH;
            }
            textLayout.drawLine(transform, (ITextComponent)activeFruit.getProvider().getDescription().func_240699_a_(strike), 90, fruitDominance0);
            strike = TextFormatting.RESET;
            if (!secondary.getSuitableFruit().contains(inactiveFruit.getProvider().getFamily()) && inactiveFruit != AlleleFruits.fruitNone) {
                strike = TextFormatting.STRIKETHROUGH;
            }
            textLayout.drawLine(transform, (ITextComponent)inactiveFruit.getProvider().getDescription().func_240699_a_(strike), 155, fruitDominance1);
            textLayout.newLine();
            textLayout.drawTranslatedLine(transform, "for.gui.family", 12);
            if (!primaryFamily.getUID().equals(EnumFruitFamily.NONE.getUID())) {
                textLayout.drawLine(transform, (ITextComponent)primaryFamily.getName(), 90, fruitDominance0);
            }
            if (!secondaryFamily.getUID().equals(EnumFruitFamily.NONE.getUID())) {
                textLayout.drawLine(transform, (ITextComponent)secondaryFamily.getName(), 155, fruitDominance1);
            }
            textLayout.endPage();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage3(MatrixStack transform, ItemStack itemStack, Screen gui) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = TreeManager.treeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            ITree tree = (ITree)optional.get();
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            WidgetManager widgetManager = guiAlyzer.getWidgetManager();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.beealyzer.produce") + ":", 12);
            textLayout.newLine();
            int x = 12;
            for (ItemStack stack : tree.getProducts().getPossibleStacks()) {
                widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.beealyzer.specialty") + ":", 12);
            textLayout.newLine();
            x = 12;
            for (ItemStack stack : tree.getSpecialties().getPossibleStacks()) {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, guiAlyzer.getGuiLeft() + x, guiAlyzer.getGuiTop() + textLayout.getLineY());
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.endPage();
        }
    }

    @Override
    public Map<ResourceLocation, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"treealyzer");
    }
}

