/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeRoot;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.CheckPollinatableTree;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeAlyzerPlugin;
import forestry.arboriculture.genetics.TreePlugin;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.genetics.root.BreedingTrackerManager;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.RenderUtil;
import forestry.modules.features.FeatureBlock;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootContext;
import genetics.api.root.IndividualRoot;
import genetics.utils.AlleleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TreeRoot
extends IndividualRoot<ITree>
implements ITreeRoot,
IBreedingTrackerHandler {
    public static final String UID = "rootTrees";
    private int treeSpeciesCount = -1;
    @Nullable
    private static ITreekeepingMode activeTreekeepingMode;
    private final Map<IFruitFamily, Collection<IFruitProvider>> providersForFamilies = new HashMap<IFruitFamily, Collection<IFruitProvider>>();
    private final List<ITreekeepingMode> treekeepingModes = new ArrayList<ITreekeepingMode>();
    private final LinkedList<ILeafTickHandler> leafTickHandlers = new LinkedList();

    public TreeRoot(IRootContext<ITree> context) {
        super(context);
        BreedingTrackerManager.INSTANCE.registerTracker(UID, this);
    }

    @Override
    public Class<? extends ITree> getMemberClass() {
        return ITree.class;
    }

    @Override
    public int getSpeciesCount() {
        if (this.treeSpeciesCount < 0) {
            this.treeSpeciesCount = (int)AlleleUtils.filteredStream(TreeChromosomes.SPECIES).filter(IAlleleForestrySpecies::isCounted).count();
        }
        return this.treeSpeciesCount;
    }

    @Override
    public ITree create(CompoundNBT compound) {
        return new Tree(compound);
    }

    @Override
    public ITree create(IGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ITree create(IGenome genome, IGenome mate) {
        return new Tree(genome, mate);
    }

    @Override
    public IGenomeWrapper createWrapper(IGenome genome) {
        return () -> genome;
    }

    @Override
    public ITree getTree(World world, IGenome genome) {
        return this.create(genome);
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    public EnumGermlingType getIconType() {
        return EnumGermlingType.SAPLING;
    }

    @Override
    public ITree getTree(World world, BlockPos pos) {
        return TileUtil.getResultFromTile((IWorldReader)world, pos, TileSapling.class, TileTreeContainer::getTree);
    }

    @Override
    @Nullable
    public ITree getTree(TileEntity tileEntity) {
        return TileUtil.getResultFromTile(tileEntity, TileLeaves.class, TileTreeContainer::getTree);
    }

    @Override
    public boolean plantSapling(World world, ITree tree, GameProfile owner, BlockPos pos) {
        BlockState state = ArboricultureBlocks.SAPLING_GE.defaultState();
        boolean placed = world.func_175656_a(pos, state);
        if (!placed) {
            return false;
        }
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!ArboricultureBlocks.SAPLING_GE.blockEqual(block)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((IBlockReader)world, pos, TileSapling.class);
        if (sapling == null) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return false;
        }
        sapling.setTree(tree.copy());
        sapling.getOwnerHandler().setOwner(owner);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        return true;
    }

    @Override
    public boolean setFruitBlock(IWorld world, IGenome genome, IAlleleFruit allele, float yield, BlockPos pos) {
        Block block;
        BlockState state;
        boolean placed;
        BlockFruitPod fruitPod;
        IFruitProvider provider = allele.getProvider();
        Direction facing = BlockUtil.getValidPodFacing(world, pos, provider.getLogTag());
        if (facing != null && ArboricultureBlocks.PODS.has(allele) && (fruitPod = (BlockFruitPod)((Object)((FeatureBlock)ArboricultureBlocks.PODS.get(allele)).getBlock())) != null && (placed = world.func_180501_a(pos, state = (BlockState)fruitPod.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)facing), 18)) && fruitPod == (block = world.func_180495_p(pos).func_177230_c())) {
            TileFruitPod pod = TileUtil.getTile((IBlockReader)world, pos, TileFruitPod.class);
            if (pod != null) {
                pod.setProperties(genome, allele, yield);
                RenderUtil.markForUpdate(pos);
                return true;
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
            return false;
        }
        return false;
    }

    @Override
    public IArboristTracker getBreedingTracker(IWorld world, @Nullable GameProfile player) {
        return (IArboristTracker)BreedingTrackerManager.INSTANCE.getTracker(this.getUID(), world, player);
    }

    @Override
    public String getFileName(@Nullable GameProfile profile) {
        return "ArboristTracker." + (profile == null ? "common" : profile.getId());
    }

    @Override
    public IBreedingTracker createTracker(String fileName) {
        return new ArboristTracker(fileName);
    }

    @Override
    public void populateTracker(IBreedingTracker tracker, @Nullable World world, @Nullable GameProfile profile) {
        if (!(tracker instanceof ArboristTracker)) {
            return;
        }
        ArboristTracker arboristTracker = (ArboristTracker)tracker;
        arboristTracker.setWorld(world);
        arboristTracker.setUsername(profile);
    }

    @Override
    public List<ITreekeepingMode> getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(IWorld world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        if (!(world instanceof World)) {
            return TreekeepingMode.normal;
        }
        IArboristTracker tracker = this.getBreedingTracker(world, null);
        String modeName = tracker.getModeName();
        ITreekeepingMode mode = this.getTreekeepingMode(modeName);
        Preconditions.checkNotNull((Object)mode);
        this.setTreekeepingMode(world, mode);
        Log.debug("Set Treekeeping mode for a world to " + mode, new Object[0]);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(IWorld world, ITreekeepingMode mode) {
        activeTreekeepingMode = mode;
        this.getBreedingTracker(world, null).setModeName(mode.getName());
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        Log.debug("Failed to find a Treekeeping mode called '%s', reverting to fallback.", new Object[0]);
        return this.treekeepingModes.get(0);
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection<ILeafTickHandler> getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return TreeAlyzerPlugin.INSTANCE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDatabasePlugin getSpeciesPlugin() {
        return TreePlugin.INSTANCE;
    }

    @Override
    public ICheckPollinatable createPollinatable(IIndividual individual) {
        Preconditions.checkArgument((boolean)(individual instanceof ITree), (Object)"individual must be a tree");
        return new CheckPollinatableTree((ITree)individual);
    }

    @Override
    @Nullable
    public IPollinatable tryConvertToPollinatable(@Nullable GameProfile owner, World world, BlockPos pos, IIndividual individual) {
        Preconditions.checkArgument((boolean)(individual instanceof ITree), (Object)"pollen must be an instance of ITree");
        ITree pollen = (ITree)individual;
        if (pollen.setLeaves((IWorld)world, owner, pos, world.field_73012_v)) {
            return TileUtil.getTile((IBlockReader)world, pos, IPollinatable.class);
        }
        return null;
    }

    @Override
    public Collection<IFruitProvider> getFruitProvidersForFruitFamily(IFruitFamily fruitFamily) {
        if (this.providersForFamilies.isEmpty()) {
            AlleleUtils.forEach(TreeChromosomes.FRUITS, fruit -> {
                IFruitProvider fruitProvider = fruit.getProvider();
                Collection fruitProviders = this.providersForFamilies.computeIfAbsent(fruitProvider.getFamily(), k -> new ArrayList());
                fruitProviders.add(fruitProvider);
            });
        }
        return this.providersForFamilies.computeIfAbsent(fruitFamily, k -> new ArrayList());
    }
}

