/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.apiculture.ModuleApiculture;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.RenderUtil;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.utils.AlleleUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.PlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer,
IButterflyNursery,
IRipeningPacketReceiver {
    private static final String NBT_RIPENING = "RT";
    private static final String NBT_DAMAGE = "ENC";
    private static final String NBT_FRUIT_LEAF = "FL";
    private static final String NBT_MATURATION = "CATMAT";
    private static final String NBT_CATERPILLAR = "CATER";
    public static final ModelProperty<ILeafSpriteProvider> SPRITE_PROVIDER = new ModelProperty();
    public static final ModelProperty<Boolean> POLLINATED = new ModelProperty();
    public static final ModelProperty<ResourceLocation> FRUIT_TEXTURE = new ModelProperty();
    private int colourFruits;
    @Nullable
    private ResourceLocation fruitSprite;
    @Nullable
    private IAlleleTreeSpecies species;
    @Nullable
    private IButterfly caterpillar;
    private boolean isFruitLeaf;
    private boolean checkFruit = true;
    private boolean isPollinatedState;
    private int ripeningTime;
    private short ripeningPeriod = (short)32766;
    private int maturationTime;
    private int damage;
    private IEffectData[] effectData = new IEffectData[2];
    private static final short hasFruitFlag = 1;
    private static final short isPollinatedFlag = 2;

    public TileLeaves() {
        super(ArboricultureTiles.LEAVES.tileType());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        ITree tree;
        super.func_230337_a_(state, compoundNBT);
        this.ripeningTime = compoundNBT.func_74765_d(NBT_RIPENING);
        this.damage = compoundNBT.func_74762_e(NBT_DAMAGE);
        this.isFruitLeaf = compoundNBT.func_74767_n(NBT_FRUIT_LEAF);
        boolean bl = this.checkFruit = !compoundNBT.func_150297_b(NBT_FRUIT_LEAF, 99);
        if (compoundNBT.func_74764_b(NBT_CATERPILLAR)) {
            this.maturationTime = compoundNBT.func_74762_e(NBT_MATURATION);
            this.caterpillar = (IButterfly)ButterflyManager.butterflyRoot.create(compoundNBT.func_74775_l(NBT_CATERPILLAR));
        }
        if ((tree = this.getTree()) != null) {
            this.setTree(tree);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        compoundNBT.func_74768_a(NBT_RIPENING, this.getRipeningTime());
        compoundNBT.func_74768_a(NBT_DAMAGE, this.damage);
        compoundNBT.func_74757_a(NBT_FRUIT_LEAF, this.isFruitLeaf);
        if (this.caterpillar != null) {
            compoundNBT.func_74768_a(NBT_MATURATION, this.maturationTime);
            CompoundNBT caterpillarNbt = new CompoundNBT();
            this.caterpillar.write(caterpillarNbt);
            compoundNBT.func_218657_a(NBT_CATERPILLAR, (INBT)caterpillarNbt);
        }
        return compoundNBT;
    }

    @Override
    public void onBlockTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        IGenome genome = tree.getGenome();
        IAlleleTreeSpecies primary = genome.getActiveAllele(TreeChromosomes.SPECIES);
        boolean isDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        for (ILeafTickHandler tickHandler : primary.getRoot().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(tree, this.field_145850_b, rand, this.func_174877_v(), isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.hasFruit() && this.getRipeningTime() < this.ripeningPeriod) {
            ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode((IWorld)this.field_145850_b);
            float sappinessModifier = treekeepingMode.getSappinessModifier(genome, 1.0f);
            float sappiness = genome.getActiveValue(TreeChromosomes.SAPPINESS).floatValue() * sappinessModifier;
            if (rand.nextFloat() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = tree.doEffect(this.effectData, this.field_145850_b, this.func_174877_v());
    }

    @Override
    public void setTree(ITree tree) {
        IFruitProvider fruitProvider;
        ITree oldTree = this.getTree();
        super.setTree(tree);
        IGenome genome = tree.getGenome();
        this.species = genome.getActiveAllele(TreeChromosomes.SPECIES);
        if (oldTree != null && !tree.equals(oldTree)) {
            this.checkFruit = true;
        }
        if (tree.canBearFruit() && this.checkFruit && this.field_145850_b != null && !this.field_145850_b.field_72995_K && (fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider()).isFruitLeaf(genome, (IWorld)this.field_145850_b, this.func_174877_v())) {
            boolean bl = this.isFruitLeaf = fruitProvider.getFruitChance(genome, (IWorld)this.field_145850_b, this.func_174877_v()) >= this.field_145850_b.field_73012_v.nextFloat();
        }
        if (this.isFruitLeaf) {
            fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                this.fruitSprite = fruitProvider.getSprite(genome, (IBlockReader)this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
            }
            this.ripeningPeriod = (short)fruitProvider.getRipeningPeriod();
        } else if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.fruitSprite = null;
        }
        this.requestModelDataUpdate();
        this.func_70296_d();
    }

    private static boolean isDestroyed(@Nullable ITree tree, int damage) {
        return tree != null && damage > tree.getResilience();
    }

    @Override
    public boolean isPollinated() {
        ITree tree = this.getTree();
        return tree != null && !TileLeaves.isDestroyed(tree, this.damage) && tree.getMate().isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFoliageColour(PlayerEntity player) {
        boolean showPollinated = this.isPollinatedState && GeneticsUtil.hasNaturalistEye(player);
        int baseColor = this.getLeafSpriteProvider().getColor(showPollinated);
        ITree tree = this.getTree();
        if (TileLeaves.isDestroyed(tree, this.damage)) {
            return ColourUtil.addRGBComponents(baseColor, 92, 61, 0);
        }
        if (this.caterpillar != null) {
            return ColourUtil.multiplyRGBComponents(baseColor, 1.5f);
        }
        return baseColor;
    }

    public int getFruitColour() {
        if (this.colourFruits == 0 && this.hasFruit()) {
            this.colourFruits = this.determineFruitColour();
        }
        return this.colourFruits;
    }

    private int determineFruitColour() {
        ITree tree = this.getTree();
        if (tree == null) {
            tree = TreeDefinition.Cherry.createIndividual();
        }
        IGenome genome = tree.getGenome();
        IFruitProvider fruit = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
        return fruit.getColour(genome, (IBlockReader)this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getLeaveSprite(boolean fancy) {
        ILeafSpriteProvider leafSpriteProvider = this.getLeafSpriteProvider();
        return leafSpriteProvider.getSprite(this.isPollinatedState, fancy);
    }

    @OnlyIn(value=Dist.CLIENT)
    private ILeafSpriteProvider getLeafSpriteProvider() {
        if (this.species != null) {
            return this.species.getLeafSpriteProvider();
        }
        IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.createIndividual().getGenome().getActiveAllele(TreeChromosomes.SPECIES);
        return oakSpecies.getLeafSpriteProvider();
    }

    @Nullable
    public ResourceLocation getFruitSprite() {
        return this.fruitSprite;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getLeaveSprite(IModelData data, boolean fancy) {
        ILeafSpriteProvider leafSpriteProvider = TileLeaves.getLeafSpriteProvider(data);
        Boolean pollinated = (Boolean)data.getData(POLLINATED);
        return leafSpriteProvider.getSprite(pollinated != null && pollinated != false, fancy);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ILeafSpriteProvider getLeafSpriteProvider(IModelData data) {
        ILeafSpriteProvider leafSpriteProvider = (ILeafSpriteProvider)data.getData(SPRITE_PROVIDER);
        if (leafSpriteProvider != null) {
            return leafSpriteProvider;
        }
        IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.createIndividual().getGenome().getActiveAllele(TreeChromosomes.SPECIES);
        return oakSpecies.getLeafSpriteProvider();
    }

    @Nullable
    public static ResourceLocation getFruitSprite(IModelData data) {
        return (ResourceLocation)data.getData(FRUIT_TEXTURE);
    }

    public IModelData getModelData() {
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(SPRITE_PROVIDER, (Object)this.getLeafSpriteProvider());
        builder.withInitial(POLLINATED, (Object)this.isPollinatedState);
        builder.withInitial(FRUIT_TEXTURE, (Object)this.fruitSprite);
        return builder.build();
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    @Override
    public PlantType getPlantType() {
        ITree tree = this.getTree();
        if (tree == null) {
            return PlantType.PLAINS;
        }
        return tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES).getPlantType();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (individual instanceof ITree) {
            ITree tree = this.getTree();
            return tree != null && !tree.getMate().isPresent() && (ModuleApiculture.doSelfPollination || !tree.isGeneticEqual(individual));
        }
        return false;
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (individual instanceof ITree) {
            ITree tree = this.getTree();
            if (tree == null || this.field_145850_b == null) {
                return;
            }
            tree.mate(individual.getGenome());
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    @Override
    public ITree getPollen() {
        return this.getTree();
    }

    private void sendNetworkUpdate() {
        NetworkUtil.sendNetworkPacket(new PacketTileStream(this), this.field_174879_c, this.field_145850_b);
    }

    private void sendNetworkUpdateRipening() {
        if (this.func_145837_r()) {
            return;
        }
        int newColourFruits = this.determineFruitColour();
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        PacketRipeningUpdate ripeningUpdate = new PacketRipeningUpdate(this);
        NetworkUtil.sendNetworkPacket(ripeningUpdate, this.field_174879_c, this.field_145850_b);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        int leafState = 0;
        boolean hasFruit = this.hasFruit();
        if (this.isPollinated()) {
            leafState = (byte)(leafState | 2);
        }
        if (hasFruit) {
            leafState = (byte)(leafState | 1);
        }
        data.writeByte(leafState);
        if (hasFruit) {
            String fruitAlleleUID = this.getTree().getGenome().getActiveAllele(TreeChromosomes.FRUITS).getRegistryName().toString();
            int colourFruits = this.getFruitColour();
            data.func_180714_a(fruitAlleleUID);
            data.writeInt(colourFruits);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        IAllele[] treeTemplate;
        String speciesUID = data.func_218666_n();
        byte leafState = data.readByte();
        this.isFruitLeaf = (leafState & 1) > 0;
        this.isPollinatedState = (leafState & 2) > 0;
        String fruitAlleleUID = null;
        if (this.isFruitLeaf) {
            fruitAlleleUID = data.func_218666_n();
            this.colourFruits = data.readInt();
        }
        if ((treeTemplate = TreeManager.treeRoot.getTemplates().getTemplate(speciesUID)) != null) {
            if (fruitAlleleUID != null) {
                AlleleUtils.actOn(new ResourceLocation(fruitAlleleUID), IAlleleFruit.class, fruitAllele -> {
                    treeTemplate[TreeChromosomes.FRUITS.getIndex()] = fruitAllele;
                });
            }
            ITree tree = (ITree)TreeManager.treeRoot.templateAsIndividual(treeTemplate);
            if (this.isPollinatedState) {
                tree.mate(tree.getGenome());
            }
            this.setTree(tree);
            RenderUtil.markForUpdate(this.field_174879_c);
        }
    }

    @Override
    public void fromRipeningPacket(int newColourFruits) {
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        RenderUtil.markForUpdate(this.field_174879_c);
    }

    @Override
    public NonNullList<ItemStack> pickFruit(ItemStack tool) {
        ITree tree = this.getTree();
        if (tree == null || !this.hasFruit()) {
            return NonNullList.func_191196_a();
        }
        NonNullList<ItemStack> produceStacks = tree.produceStacks(this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return produceStacks;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        ITree tree = this.getTree();
        if (tree == null) {
            return EnumFruitFamily.NONE;
        }
        return tree.getGenome().getActiveAllele(TreeChromosomes.FRUITS).getProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.ripeningPeriod == 0) {
            return 1.0f;
        }
        if (this.getTree() == null) {
            return 0.0f;
        }
        return (float)this.getRipeningTime() / (float)this.ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !TileLeaves.isDestroyed(this.getTree(), this.damage);
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || !this.isFruitLeaf || this.getRipeningTime() >= this.ripeningPeriod) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.ripeningPeriod * add);
        this.sendNetworkUpdateRipening();
    }

    @Nullable
    public String getSpeciesUID() {
        if (this.species == null) {
            return null;
        }
        return this.species.getRegistryName().toString();
    }

    private void matureCaterpillar() {
        if (this.caterpillar == null) {
            return;
        }
        ++this.maturationTime;
        ITree tree = this.getTree();
        boolean wasDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        this.damage += this.caterpillar.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM).intValue();
        IGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getActiveValue(ButterflyChromosomes.LIFESPAN).intValue() / (float)(caterpillarGenome.getActiveValue(ButterflyChromosomes.FERTILITY) * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            ButterflyManager.butterflyRoot.plantCocoon((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b(), this.getCaterpillar(), this.getOwnerHandler().getOwner(), 0, false);
            this.setCaterpillar(null);
        } else if (!wasDestroyed && TileLeaves.isDestroyed(tree, this.damage)) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    @Override
    @Nullable
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(@Nullable IButterfly caterpillar) {
        this.maturationTime = 0;
        this.caterpillar = caterpillar;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly caterpillar) {
        ITree tree = this.getTree();
        return !TileLeaves.isDestroyed(tree, this.damage) && this.caterpillar == null;
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_226691_t_(this.field_174879_c);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_174879_c);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getBiome().func_76727_i());
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }
}

