/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureEbony
extends FeatureTree {
    public FeatureEbony(ITreeGenData tree) {
        super(tree, 10, 4);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        int trunksGenerated = 0;
        for (int x = 0; x < this.girth; ++x) {
            for (int z = 0; z < this.girth; ++z) {
                if (rand.nextFloat() < 0.6f) {
                    for (int y = 0; y < this.height; ++y) {
                        FeatureHelper.addBlock(world, startPos.func_177982_a(x, y, z), wood, FeatureHelper.EnumReplaceMode.ALL);
                        if (y > this.height / 2 && rand.nextFloat() < 0.1f * (float)(10 / this.height)) break;
                    }
                    ++trunksGenerated;
                    continue;
                }
                for (int i = 0; i < 1; ++i) {
                    world.func_180501_a(startPos.func_177982_a(x, i, z), Blocks.field_150350_a.func_176223_P(), 18);
                }
            }
        }
        if (trunksGenerated <= 0) {
            FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, 1, 0, 0.6f, null, 0.0f);
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        for (int times = 0; times < 2 * this.height; ++times) {
            int h = 2 * this.girth + rand.nextInt(this.height - this.girth);
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = rand.nextInt(this.girth);
            int y_off = rand.nextInt(this.girth);
            BlockPos center = startPos.func_177982_a(x_off, h, y_off);
            int radius = 1 + rand.nextInt(this.girth);
            FeatureHelper.generateSphere(world, center, radius, leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

