/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimateTransformer;
import forestry.climatology.features.ClimatologyItems;
import forestry.climatology.items.ItemHabitatScreen;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.TickHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class PreviewHandlerClient {
    private final TickHelper tickHelper = new TickHelper();
    private final PreviewRenderer renderer = new PreviewRenderer();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent tickEvent) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        this.tickHelper.onTick();
        if (this.tickHelper.updateOnInterval(100)) {
            ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
            if (stack.func_190926_b() || !ClimatologyItems.HABITAT_SCREEN.itemEqual(stack) || !ItemHabitatScreen.isValid(stack, player.field_70170_p) || !ItemHabitatScreen.isPreviewModeActive(stack)) {
                this.renderer.clearPreview();
                return;
            }
            BlockPos currentPos = ItemHabitatScreen.getPosition(stack);
            if (currentPos == null || player.func_70092_e((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p()) > 16384.0) {
                this.renderer.clearPreview();
                return;
            }
            LazyOptional<IClimateTransformer> transformer = TileUtil.getInterface(world, currentPos, ClimateCapabilities.CLIMATE_TRANSFORMER, null);
            if (!transformer.isPresent()) {
                this.renderer.clearPreview();
                return;
            }
            transformer.ifPresent(t -> this.renderer.updatePreview(currentPos, t.getRange(), t.isCircular()));
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.renderer.clearPreview();
    }

    private class PreviewRenderer {
        private final Set<BlockPos> previewPositions = new HashSet<BlockPos>();
        private final AxisAlignedBB boundingBox = VoxelShapes.func_197868_b().func_197752_a().func_186664_h(0.125);
        private boolean addedToBus = false;
        @Nullable
        private BlockPos previewOrigin = null;
        private int range = -1;
        private boolean circular;

        private PreviewRenderer() {
        }

        public void setPreview(BlockPos centerPosition, int range, boolean circular) {
            this.previewPositions.clear();
            BlockPos center = new BlockPos(0, 0, 0);
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    boolean valid;
                    BlockPos position = centerPosition.func_177982_a(x, 0, y);
                    if (circular) {
                        double distance = Math.round(Math.sqrt(center.func_218140_a((double)x, 0.0, (double)y, true)));
                        valid = distance <= (double)range && distance > (double)(range - 1);
                    } else {
                        boolean bl = valid = x == -range || x == range || y == -range || y == range;
                    }
                    if (!valid) continue;
                    this.previewPositions.add(position);
                }
            }
            this.previewOrigin = centerPosition;
            this.range = range;
            this.circular = circular;
            if (!this.addedToBus) {
                this.addedToBus = true;
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }

        public boolean isPreviewOrigin(BlockPos pos) {
            return pos.equals((Object)this.previewOrigin);
        }

        @Nullable
        public BlockPos getPreviewOrigin() {
            return this.previewOrigin;
        }

        public void updatePreview(BlockPos centerPosition, int range, boolean circular) {
            if (centerPosition == this.previewOrigin || range != this.range || circular != this.circular) {
                this.setPreview(centerPosition, range, circular);
            }
        }

        public void clearPreview() {
            this.previewOrigin = null;
            this.circular = false;
            this.range = -1;
            this.previewPositions.clear();
            MinecraftForge.EVENT_BUS.unregister((Object)PreviewHandlerClient.this.renderer);
            this.addedToBus = false;
        }

        @SubscribeEvent
        public void onWorldRenderLast(RenderWorldLastEvent event) {
            if (this.previewPositions.isEmpty()) {
                return;
            }
            float partialTicks = event.getPartialTicks();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            double playerX = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
            double playerY = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks;
            double playerZ = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.lineWidth((float)6.0f);
            RenderSystem.disableDepthTest();
            for (BlockPos position : this.previewPositions) {
                AxisAlignedBB axisAlignedBB = this.boundingBox.func_186670_a(position);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }
}

