/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.apiculture.ApiaristAI;
import forestry.apiculture.villagers.RegisterVillager;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.modules.ModuleManager;
import genetics.api.GeneticsAPI;
import genetics.api.root.IRootDefinition;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="forestry")
public class EventHandlerCore {
    @SubscribeEvent
    public static void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        for (IPickupHandler handler : ModuleManager.pickupHandlers) {
            if (!handler.onItemPickup(event.getPlayer(), event.getItem())) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        EventHandlerCore.syncBreedingTrackers(player);
    }

    @SubscribeEvent
    public static void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        EventHandlerCore.syncBreedingTrackers(player);
    }

    private static void syncBreedingTrackers(PlayerEntity player) {
        Collection<IRootDefinition> speciesRoots = GeneticsAPI.apiInstance.getRoots().values();
        for (IRootDefinition definition : speciesRoots) {
            Object root;
            if (!definition.isPresent() || !((root = definition.get()) instanceof IForestrySpeciesRoot)) continue;
            IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)root;
            IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((IWorld)player.func_130014_f_(), player.func_146103_bH());
            breedingTracker.synchToPlayer(player);
        }
    }

    @SubscribeEvent
    public static void handleWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        for (ISaveEventHandler handler : ModuleManager.saveEventHandlers) {
            handler.onWorldLoad(world);
        }
    }

    @SubscribeEvent
    public static void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : ModuleManager.saveEventHandlers) {
            handler.onWorldSave(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : ModuleManager.saveEventHandlers) {
            handler.onWorldUnload(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        VillagerEntity villager;
        VillagerProfession prof;
        Entity entity = event.getEntity();
        if (entity instanceof VillagerEntity && (prof = (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(EntityType.func_200718_a((EntityType)(villager = (VillagerEntity)entity).func_200600_R()))).getRegistryName().equals((Object)RegisterVillager.BEEKEEPER)) {
            villager.field_70714_bg.func_75776_a(6, (Goal)new ApiaristAI(villager, 0.6));
        }
    }
}

