/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.config.Config;
import forestry.core.utils.RenderUtil;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public class BlockHumus
extends Block {
    private static final int degradeDelimiter = Config.humusDegradeDelimiter;
    public static final IntegerProperty DEGRADE = IntegerProperty.func_177719_a((String)"degrade", (int)0, (int)degradeDelimiter);

    public BlockHumus() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DEGRADE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DEGRADE});
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.field_72995_K || world.field_73012_v.nextInt(140) != 0) {
            return;
        }
        if (BlockHumus.isEnrooted((World)world, pos)) {
            BlockHumus.degradeSoil((World)world, pos);
        }
    }

    private static boolean isEnrooted(World world, BlockPos pos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos blockPos;
                BlockState state;
                Block block;
                if (i == 0 && j == 0 || !(block = (state = world.func_180495_p(blockPos = pos.func_177982_a(i, 1, j))).func_177230_c()).func_203417_a((ITag)BlockTags.field_200031_h) && !(block instanceof IGrowable)) continue;
                return true;
            }
        }
        return false;
    }

    private static void degradeSoil(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        int degrade = (Integer)blockState.func_177229_b((Property)DEGRADE);
        if (++degrade >= degradeDelimiter) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
        } else {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DEGRADE, (Comparable)Integer.valueOf(degrade)), 2);
        }
        RenderUtil.markForUpdate(pos);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction direction, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos);
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }
}

