/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.google.common.base.Preconditions;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.IShapeProvider;
import forestry.core.blocks.ISimpleShapeProvider;
import forestry.core.tiles.TileForestry;
import forestry.modules.features.FeatureTileType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class MachineProperties<T extends TileForestry>
implements IMachineProperties<T> {
    private static final ISimpleShapeProvider FULL_CUBE = VoxelShapes::func_197868_b;
    private final String name;
    private final Supplier<FeatureTileType<? extends T>> teType;
    private final IShapeProvider shape;
    @Nullable
    private Block block;

    public MachineProperties(Supplier<FeatureTileType<? extends T>> teType, String name, IShapeProvider shape) {
        this.teType = teType;
        this.name = name;
        this.shape = shape;
    }

    @Override
    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Override
    public VoxelShape getShape(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.shape.getShape(state, reader, pos, context);
    }

    @Override
    public TileEntity createTileEntity() {
        return this.teType.get().getTileType().func_200968_a();
    }

    @Override
    public TileEntityType<? extends T> getTeType() {
        return this.teType.get().getTileType();
    }

    public String func_176610_l() {
        return this.name;
    }

    static /* synthetic */ ISimpleShapeProvider access$000() {
        return FULL_CUBE;
    }

    public static class Builder<T extends TileForestry, B extends Builder<T, ?>> {
        @Nullable
        protected Supplier<FeatureTileType<? extends T>> type;
        @Nullable
        protected String name;
        protected IShapeProvider shape = MachineProperties.access$000();

        public Builder(Supplier<FeatureTileType<? extends T>> type, String name) {
            this.type = type;
            this.name = name;
        }

        public Builder() {
        }

        public B setName(String name) {
            this.name = name;
            return (B)this;
        }

        public B setType(Supplier<FeatureTileType<? extends T>> teType) {
            this.type = teType;
            return (B)this;
        }

        public B setShape(VoxelShape shape) {
            return this.setShape(() -> shape);
        }

        public B setShape(ISimpleShapeProvider shape) {
            this.shape = shape;
            return (B)this;
        }

        public B setShape(IShapeProvider shape) {
            this.shape = shape;
            return (B)this;
        }

        public MachineProperties<T> create() {
            Preconditions.checkNotNull(this.type);
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.shape);
            return new MachineProperties<T>(this.type, this.name, this.shape);
        }
    }
}

