/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.climate.IWorldClimateHolder;
import forestry.api.climate.Position2D;
import forestry.api.core.INbtWritable;
import forestry.core.climate.ClimateStateHelper;
import it.unimi.dsi.fastutil.longs.Long2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class WorldClimateHolder
extends WorldSavedData
implements IWorldClimateHolder {
    private static final TransformerData DEFAULT_DATA = new TransformerData(0L, ClimateStateHelper.INSTANCE.absent(), 0, false, new long[0]);
    static final String NAME = "forestry_climate";
    private static final String TRANSFORMERS_KEY = "Transformers";
    private static final String CHUNK_KEY = "Chunk";
    private static final String TRANSFORMERS_DATA_KEY = "Data";
    private static final String STATE_DATA_KEY = "Data";
    private static final String POS_KEY = "Pos";
    private static final String RANGE_KEY = "Range";
    private static final String CIRCULAR_KEY = "circular";
    private static final String CHUNKS_KEY = "Chunks";
    private final Long2ObjectMap<TransformerData> transformers = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<long[]> transformersByChunk = new Long2ObjectOpenHashMap();
    private final Long2LongMap chunkUpdates = new Long2LongArrayMap();
    @Nullable
    private World world;

    public WorldClimateHolder(String name) {
        super(name);
    }

    public void setWorld(@Nullable World world) {
        this.world = world;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.transformers.clear();
        ListNBT transformerData = nbt.func_150295_c(TRANSFORMERS_KEY, 10);
        for (int i = 0; i < transformerData.size(); ++i) {
            CompoundNBT tagCompound = transformerData.func_150305_b(i);
            TransformerData data = new TransformerData(tagCompound);
            this.transformers.put(data.position, (Object)data);
        }
        ListNBT chunkData = nbt.func_150295_c(CHUNK_KEY, 10);
        for (int i = 0; i < chunkData.size(); ++i) {
            CompoundNBT tagCompound = chunkData.func_150305_b(i);
            long pos = tagCompound.func_74763_f(POS_KEY);
            long[] chunkTransformers = tagCompound.func_197645_o("Data");
            this.transformersByChunk.put(pos, (Object)chunkTransformers);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT transformerData = new ListNBT();
        for (Map.Entry entry : this.transformers.long2ObjectEntrySet()) {
            TransformerData data = (TransformerData)entry.getValue();
            transformerData.add((Object)data.write(new CompoundNBT()));
        }
        compound.func_218657_a(TRANSFORMERS_KEY, (INBT)transformerData);
        ListNBT chunkData = new ListNBT();
        for (Map.Entry entry : this.transformersByChunk.long2ObjectEntrySet()) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74772_a(POS_KEY, ((Long)entry.getKey()).longValue());
            tagCompound.func_218657_a("Data", (INBT)new LongArrayNBT((long[])entry.getValue()));
            chunkData.add((Object)tagCompound);
        }
        compound.func_218657_a(CHUNK_KEY, (INBT)chunkData);
        return compound;
    }

    @Override
    public IClimateState getClimate(long position) {
        return ((TransformerData)this.transformers.getOrDefault(position, (Object)DEFAULT_DATA)).climateState;
    }

    @Override
    public void addTransformer(long chunkPos, long transformerPos) {
        long[] newData;
        long[] oldData = (long[])this.transformersByChunk.get(chunkPos);
        if (oldData != null) {
            for (long pos : oldData) {
                if (pos != transformerPos) continue;
                return;
            }
            newData = Arrays.copyOf(oldData, oldData.length + 1);
        } else {
            newData = new long[1];
        }
        newData[newData.length - 1] = transformerPos;
        this.transformersByChunk.put(chunkPos, (Object)newData);
        this.func_76186_a(true);
        this.markChunkUpdate(chunkPos);
    }

    @Override
    public void removeTransformer(long chunkPos, long transformerPos) {
        long[] oldData = (long[])this.transformersByChunk.get(chunkPos);
        if (oldData == null) {
            return;
        }
        for (long pos : oldData) {
            if (pos != transformerPos) continue;
            if (oldData.length == 1) {
                this.transformersByChunk.remove(chunkPos);
                this.chunkUpdates.remove(chunkPos);
            } else {
                long[] newData = Arrays.copyOf(oldData, oldData.length - 1);
                this.transformersByChunk.put(chunkPos, (Object)newData);
            }
            this.func_76186_a(true);
            this.markChunkUpdate(chunkPos);
            return;
        }
    }

    private void markChunkUpdate(long chunkPos) {
        if (this.world != null) {
            this.chunkUpdates.put(chunkPos, this.world.func_82737_E());
        }
    }

    @Override
    public void updateTransformer(IClimateTransformer transformer) {
        BlockPos position = transformer.getCoordinates();
        long longPos = position.func_218275_a();
        TransformerData data = (TransformerData)this.transformers.get(longPos);
        if (data != null) {
            boolean needChunkUpdate = data.range != transformer.getRange() || data.circular != transformer.isCircular() || data.chunks.length == 0;
            boolean needClimateUpdate = !data.climateState.equals(transformer.getCurrent());
            data.climateState = transformer.getCurrent().toImmutable();
            if (needChunkUpdate) {
                data.circular = transformer.isCircular();
                data.range = transformer.getRange();
                TransformerData.access$602(data, this.updateTransformerChunks(transformer, needClimateUpdate));
            } else if (needClimateUpdate) {
                for (long chunkPos : data.chunks) {
                    this.markChunkUpdate(chunkPos);
                }
            }
        } else {
            long[] transformerChunks = this.updateTransformerChunks(transformer, false);
            this.transformers.put(longPos, (Object)new TransformerData(longPos, transformer.getCurrent().toImmutable(), transformer.getRange(), transformer.isCircular(), transformerChunks));
        }
        this.func_76186_a(true);
    }

    private long[] updateTransformerChunks(IClimateTransformer transformer, boolean forceDirty) {
        BlockPos transformerPos = transformer.getCoordinates();
        long longPos = transformerPos.func_218275_a();
        int range = transformer.getRange();
        HashSet<Long> chunkSet = new HashSet<Long>();
        for (int x = transformerPos.func_177958_n() - range; x <= transformerPos.func_177958_n() + range; x += 16) {
            for (int z = transformerPos.func_177952_p() - range; z <= transformerPos.func_177952_p() + range; z += 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                long chunkPos = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
                this.addTransformer(chunkPos, longPos);
                chunkSet.add(chunkPos);
                if (!forceDirty) continue;
                this.markChunkUpdate(chunkPos);
            }
        }
        return chunkSet.stream().mapToLong(l -> l).toArray();
    }

    @Override
    public void removeTransformer(IClimateTransformer transformer) {
        this.removeTransformerChunks(transformer);
        this.transformers.remove(transformer.getCoordinates().func_218275_a());
        this.func_76186_a(true);
    }

    private void removeTransformerChunks(IClimateTransformer transformer) {
        BlockPos transformerPos = transformer.getCoordinates();
        long longPos = transformerPos.func_218275_a();
        TransformerData data = (TransformerData)this.transformers.get(longPos);
        if (data == null) {
            return;
        }
        for (long chunkPos : data.chunks) {
            this.removeTransformer(chunkPos, longPos);
        }
    }

    @Override
    public int getRange(long position) {
        return ((TransformerData)this.transformers.getOrDefault(position, (Object)DEFAULT_DATA)).range;
    }

    @Override
    public boolean isCircular(long position) {
        return ((TransformerData)this.transformers.getOrDefault(position, (Object)DEFAULT_DATA)).circular;
    }

    @Override
    public boolean isPositionInTransformerRange(long position, Position2D blockPos) {
        BlockPos pos = BlockPos.func_218283_e((long)position);
        int range = this.getRange(position);
        if (this.isCircular(position)) {
            double distance = Math.round(blockPos.getDistance(pos));
            return (float)range > 0.0f && distance <= (double)range;
        }
        return MathHelper.func_76130_a((int)(blockPos.getX() - pos.func_177958_n())) <= range && MathHelper.func_76130_a((int)(blockPos.getZ() - pos.func_177952_p())) <= range;
    }

    @Override
    public IClimateState getState(BlockPos pos) {
        long chunkPos = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        if (!this.transformersByChunk.containsKey(chunkPos)) {
            return ClimateStateHelper.INSTANCE.absent();
        }
        double transformerCount = 0.0;
        IClimateState state = ClimateStateHelper.INSTANCE.mutableZero();
        for (long transformerPos : (long[])this.transformersByChunk.get(chunkPos)) {
            if (!this.isPositionInTransformerRange(transformerPos, new Position2D((Vector3i)pos))) continue;
            state = state.add(this.getClimate(transformerPos));
            transformerCount += 1.0;
        }
        return transformerCount > 0.0 ? state.multiply(1.0 / transformerCount).toImmutable() : ClimateStateHelper.INSTANCE.absent();
    }

    @Override
    public boolean hasTransformers(BlockPos pos) {
        return this.transformersByChunk.containsKey(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)));
    }

    @Override
    public long getLastUpdate(BlockPos pos) {
        return this.getLastUpdate(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)));
    }

    @Override
    public long getLastUpdate(long chunkPos) {
        return this.chunkUpdates.get(chunkPos);
    }

    private static class TransformerData
    implements INbtWritable {
        private final long position;
        private IClimateState climateState;
        private int range;
        private boolean circular;
        private long[] chunks;

        private TransformerData(long position, IClimateState climateState, int range, boolean circular, long[] chunks) {
            this.position = position;
            this.climateState = climateState;
            this.range = range;
            this.circular = circular;
            this.chunks = chunks;
        }

        private TransformerData(CompoundNBT nbt) {
            this.position = nbt.func_74763_f(WorldClimateHolder.POS_KEY);
            this.range = nbt.func_74762_e(WorldClimateHolder.RANGE_KEY);
            this.climateState = ClimateStateHelper.INSTANCE.create(nbt.func_74775_l("Data"));
            this.circular = nbt.func_74767_n(WorldClimateHolder.CIRCULAR_KEY);
            this.chunks = nbt.func_197645_o(WorldClimateHolder.CHUNKS_KEY);
        }

        @Override
        public CompoundNBT write(CompoundNBT nbt) {
            nbt.func_74772_a(WorldClimateHolder.POS_KEY, this.position);
            nbt.func_218657_a("Data", (INBT)ClimateStateHelper.INSTANCE.writeToNBT(new CompoundNBT(), this.climateState));
            nbt.func_74768_a(WorldClimateHolder.RANGE_KEY, this.range);
            nbt.func_74757_a(WorldClimateHolder.CIRCULAR_KEY, this.circular);
            nbt.func_218657_a(WorldClimateHolder.CHUNKS_KEY, (INBT)new LongArrayNBT(this.chunks));
            return nbt;
        }

        static /* synthetic */ long[] access$602(TransformerData x0, long[] x1) {
            x0.chunks = x1;
            return x1;
        }
    }
}

