/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.core.utils.Translator;
import forestry.modules.ModuleManager;
import genetics.commands.CommandHelpers;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandModules {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"module").then(CommandPluginsInfo.register())).executes(CommandModules::listModulesForSender);
    }

    private static int listModulesForSender(CommandContext<CommandSource> context) {
        StringBuilder pluginList = new StringBuilder();
        for (IForestryModule module : ModuleManager.getLoadedModules()) {
            if (pluginList.length() > 0) {
                pluginList.append(", ");
            }
            pluginList.append(CommandModules.makeListEntry(module));
        }
        CommandHelpers.sendChatMessage((CommandSource)context.getSource(), pluginList.toString());
        return 1;
    }

    private static String makeListEntry(IForestryModule module) {
        String entry = module.isAvailable() ? TextFormatting.GREEN.toString() : TextFormatting.RED.toString();
        ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
        if (info != null) {
            entry = entry + info.moduleID();
            if (!info.version().isEmpty()) {
                entry = entry + " (" + info.version() + ")";
            }
        } else {
            entry = entry + "???";
        }
        return entry;
    }

    public static class CommandPluginsInfo {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"module", (ArgumentType)ModuleArgument.modules()).executes(CommandPluginsInfo::listModuleInfoForSender));
        }

        private static int listModuleInfoForSender(CommandContext<CommandSource> context) throws CommandException {
            IForestryModule found = (IForestryModule)context.getArgument("module", IForestryModule.class);
            TextFormatting formatting = found.isAvailable() ? TextFormatting.GREEN : TextFormatting.RED;
            ForestryModule info = found.getClass().getAnnotation(ForestryModule.class);
            if (info != null) {
                CommandSource sender = (CommandSource)context.getSource();
                CommandHelpers.sendChatMessage(sender, formatting + "Module: " + info.name());
                if (!info.version().isEmpty()) {
                    CommandHelpers.sendChatMessage(sender, TextFormatting.BLUE + "Version: " + info.version());
                }
                if (!info.author().isEmpty()) {
                    CommandHelpers.sendChatMessage(sender, TextFormatting.BLUE + "Author(s): " + info.author());
                }
                if (!info.url().isEmpty()) {
                    CommandHelpers.sendChatMessage(sender, TextFormatting.BLUE + "URL: " + info.url());
                }
                if (!info.unlocalizedDescription().isEmpty()) {
                    CommandHelpers.sendChatMessage(sender, Translator.translateToLocal(info.unlocalizedDescription()));
                }
                return 1;
            }
            return 0;
        }

        public static class ModuleArgument
        implements ArgumentType<IForestryModule> {
            public IForestryModule parse(StringReader reader) throws CommandSyntaxException {
                String pluginUid = reader.readUnquotedString();
                IForestryModule found = null;
                for (IForestryModule module : ModuleManager.getLoadedModules()) {
                    ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
                    if (info == null) continue;
                    String id = info.moduleID();
                    String name = info.name();
                    if (!id.equalsIgnoreCase(pluginUid) && !name.equalsIgnoreCase(pluginUid)) continue;
                    found = module;
                    break;
                }
                if (found != null) {
                    return found;
                }
                throw new SimpleCommandExceptionType((Message)new TranslationTextComponent("for.chat.modules.error", new Object[]{pluginUid})).createWithContext((ImmutableStringReader)reader);
            }

            public static ModuleArgument modules() {
                return new ModuleArgument();
            }

            public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
                ModuleManager.getLoadedModules().stream().map(module -> module.getClass().getAnnotation(ForestryModule.class)).filter(Objects::nonNull).forEach(info -> builder.suggest(info.moduleID()));
                return builder.buildFuture();
            }
        }
    }
}

