/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Table;
import forestry.core.data.BlockStateProvider;
import forestry.core.fluids.ForestryFluids;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.farming.blocks.BlockFarm;
import forestry.farming.features.FarmingBlocks;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.modules.features.FeatureBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;

public class ForestryBlockStateProvider
extends BlockStateProvider {
    public ForestryBlockStateProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerStates() {
        for (ForestryFluids fluid : ForestryFluids.values()) {
            Object block = fluid.getFeature().fluidBlock().block();
            this.addVariants((Block)block, new BlockStateProvider.Builder().alwaysIgnore(new Property[]{FlowingFluidBlock.field_176367_b}).always(variant -> variant.model("forestry:block/fluid_" + fluid.getTag().func_110623_a())));
        }
        this.addCocoon(LepidopterologyBlocks.COCOON);
        this.addCocoon(LepidopterologyBlocks.COCOON_SOLID);
        for (BlockFarm farm : FarmingBlocks.FARM.getBlocks()) {
            this.addVariants(farm, new BlockStateProvider.Builder().always(variant -> variant.model("forestry:block/farm")));
        }
        for (Table.Cell cell : CultivationBlocks.PLANTER.getFeatureByTypes().cellSet()) {
            this.addCultivationBlock((FeatureBlock)cell.getValue(), (BlockTypePlanter)cell.getRowKey());
        }
    }

    private void addCultivationBlock(FeatureBlock<? extends Block, BlockItem> feature, BlockTypePlanter planter) {
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().always(variant -> variant.model("forestry:block/" + planter.func_176610_l())).property(BlockStateProperties.field_208155_H, Direction.EAST, variant -> variant.rotationY(90)).property(BlockStateProperties.field_208155_H, Direction.SOUTH, variant -> variant.rotationY(180)).property(BlockStateProperties.field_208155_H, Direction.WEST, variant -> variant.rotationY(270)));
    }

    private void addCocoon(FeatureBlock<? extends Block, BlockItem> feature) {
        BlockState state = feature.defaultState();
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().property(AlleleButterflyCocoon.AGE, 0, variant -> variant.model("forestry:block/cocoon_early")).property(AlleleButterflyCocoon.AGE, 1, variant -> variant.model("forestry:block/cocoon_middle")).property(AlleleButterflyCocoon.AGE, 2, variant -> variant.model("forestry:block/cocoon_late")).state((BlockState)((BlockState)state.func_206870_a((Property)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(2))).func_206870_a((Property)AlleleButterflyCocoon.COCOON, (Comparable)ButterflyAlleles.cocoonSilk), variant -> variant.model("forestry:block/cocoon_silk_late")));
    }
}

