/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.circuits.ICircuit;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumHoneyDrop;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.climatology.features.ClimatologyBlocks;
import forestry.climatology.features.ClimatologyItems;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.blocks.EnumResourceType;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.data.ForestryTags;
import forestry.core.data.builder.RecipeDataHelper;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.ItemFruit;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.recipes.ComplexIngredient;
import forestry.core.recipes.ModuleEnabledCondition;
import forestry.cultivation.blocks.BlockPlanter;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.database.features.DatabaseBlocks;
import forestry.energy.blocks.BlockTypeEngine;
import forestry.energy.features.EnergyBlocks;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.features.FarmingBlocks;
import forestry.food.features.FoodItems;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.mail.blocks.BlockTypeMail;
import forestry.mail.features.MailBlocks;
import forestry.mail.features.MailItems;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.sorting.features.SortingBlocks;
import forestry.storage.features.BackpackItems;
import forestry.worktable.features.WorktableBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.apache.logging.log4j.util.TriConsumer;

public class ForestryRecipeProvider
extends RecipeProvider {
    public ForestryRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        RecipeDataHelper helper = new RecipeDataHelper(consumer);
        this.registerArboricultureRecipes(helper);
        this.registerApicultureRecipes(helper);
        this.registerFoodRecipes(helper);
        this.registerBackpackRecipes(helper);
        this.registerCharcoalRecipes(helper);
        this.registerClimatologyRecipes(helper);
        this.registerCoreRecipes(helper);
        this.registerBookRecipes(helper);
        this.registerCultivationRecipes(helper);
        this.registerDatabaseRecipes(helper);
        this.registerEnergyRecipes(helper);
        this.registerFactoryRecipes(helper);
        this.registerFarmingRecipes(helper);
        this.registerFluidsRecipes(helper);
        this.registerLepidopterologyRecipes(helper);
        this.registerMailRecipes(helper);
        this.registerSortingRecipes(helper);
        this.registerWorktableRecipes(helper);
    }

    private void registerApicultureRecipes(RecipeDataHelper helper) {
        this.registerCombRecipes(helper);
        BlockAlveary plain = (BlockAlveary)((Object)((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.PLAIN)).block());
        Object goldElectronTube = ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)).item();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)plain).func_200462_a(Character.valueOf('X'), CoreItems.IMPREGNATED_CASING.item()).func_200462_a(Character.valueOf('#'), ((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING)).item()).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.IMPREGNATED_CASING.item())).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.FAN)).block()).func_200462_a(Character.valueOf('#'), goldElectronTube).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200472_a("I I").func_200472_a(" X ").func_200472_a("I#I").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HEATER)).block()).func_200462_a(Character.valueOf('#'), goldElectronTube).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200472_a("#I#").func_200472_a(" X ").func_200472_a("SSS").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.HYGRO)).block()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200472_a("GIG").func_200472_a("GXG").func_200472_a("GIG").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SIEVE)).block()).func_200462_a(Character.valueOf('W'), ((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK)).item()).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200472_a("III").func_200472_a(" X ").func_200472_a("WWW").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.STABILISER)).block()).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GEMS_QUARTZ).func_200472_a("G G").func_200472_a("GXG").func_200472_a("G G").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.ALVEARY.get(BlockAlvearyType.SWARMER)).block()).func_200462_a(Character.valueOf('#'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND)).item()).func_200462_a(Character.valueOf('X'), (IItemProvider)plain).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.INGOTS_GOLD).func_200472_a("#G#").func_200472_a(" X ").func_200472_a("#G#").func_200465_a("has_plain", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)plain)).func_200473_b("alveary")).func_200464_a(arg_0), "apiculture");
        Object wovenSilk = ((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK)).item();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.APIARIST_HELMET.item()).func_200462_a(Character.valueOf('#'), wovenSilk).func_200472_a("###").func_200472_a("# #").func_200465_a("has silk", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(wovenSilk)).func_200473_b("apiarist_armour")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.APIARIST_CHEST.item()).func_200462_a(Character.valueOf('#'), wovenSilk).func_200472_a("# #").func_200472_a("###").func_200472_a("###").func_200465_a("has silk", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(wovenSilk)).func_200473_b("apiarist_armour")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.APIARIST_LEGS.item()).func_200462_a(Character.valueOf('#'), wovenSilk).func_200472_a("###").func_200472_a("# #").func_200472_a("# #").func_200465_a("has silk", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(wovenSilk)).func_200473_b("apiarist_armour")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.APIARIST_BOOTS.item()).func_200462_a(Character.valueOf('#'), wovenSilk).func_200472_a("# #").func_200472_a("# #").func_200465_a("has silk", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(wovenSilk)).func_200473_b("apiarist_armour")).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).block()).func_200469_a(Character.valueOf('S'), (ITag)ItemTags.field_202899_i).func_200469_a(Character.valueOf('P'), (ITag)ItemTags.field_199905_b).func_200462_a(Character.valueOf('C'), CoreItems.IMPREGNATED_CASING.item()).func_200472_a("SSS").func_200472_a("PCP").func_200472_a("PPP").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.IMPREGNATED_CASING.item()))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.BEE_HOUSE)).block()).func_200469_a(Character.valueOf('S'), (ITag)ItemTags.field_202899_i).func_200469_a(Character.valueOf('P'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('C'), ForestryTags.Items.BEE_COMBS).func_200472_a("SSS").func_200472_a("PCP").func_200472_a("PPP").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.BEE_COMBS))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureBlocks.BEE_CHEST.block()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.BEE_COMBS).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a(" G ").func_200472_a("XYX").func_200472_a("XXX").func_200465_a("has_comb", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.BEE_COMBS))).func_200464_a(arg_0), "apiculture");
        Object propolis = ((FeatureItem)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)).item();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.BITUMINOUS_PEAT.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.DUSTS_ASH).func_200462_a(Character.valueOf('X'), CoreItems.PEAT.item()).func_200462_a(Character.valueOf('Y'), propolis).func_200472_a(" # ").func_200472_a("XYX").func_200472_a(" # ").func_200465_a("has_propolis", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(propolis))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.FRAME_IMPREGNATED.item()).func_200462_a(Character.valueOf('#'), CoreItems.STICK_IMPREGNATED.item()).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STRING).func_200472_a("###").func_200472_a("#S#").func_200472_a("###").func_200465_a("has_impregnated_stick", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STICK_IMPREGNATED.item()))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.FRAME_UNTREATED.item()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STRING).func_200472_a("###").func_200472_a("#S#").func_200472_a("###").func_200465_a("has_impregnated_stick", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STICK_IMPREGNATED.item()))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.HABITAT_LOCATOR.item()).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200472_a(" X ").func_200472_a("X#X").func_200472_a(" X ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH)).item()).func_200462_a(Character.valueOf('#'), ((FeatureItem)ApicultureItems.PROPOLIS.get(EnumPropolis.PULSATING)).item()).func_200472_a("# #").func_200472_a(" # ").func_200472_a("# #").func_200465_a("has_pulsating_propolis", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(((FeatureItem)ApicultureItems.PROPOLIS.get(EnumPropolis.PULSATING)).item()))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.SCOOP.item()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('X'), (ITag)ItemTags.field_199904_a).func_200472_a("#X#").func_200472_a("###").func_200472_a(" # ").func_200465_a("has_wool", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_199904_a))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(consumer -> ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151123_aH).func_200462_a(Character.valueOf('#'), (IItemProvider)propolis).func_200462_a(Character.valueOf('X'), ((FeatureItem)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)).item()).func_200472_a("#X#").func_200472_a("#X#").func_200472_a("#X#").func_200465_a("has_propolis", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)propolis)).func_200467_a(consumer, new ResourceLocation("forestry", "slime_from_propolis")), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.SMOKER.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151033_d).func_200469_a(Character.valueOf('L'), (ITag)Tags.Items.LEATHER).func_200472_a("LS#").func_200472_a("LF#").func_200472_a("###").func_200465_a("has_tin", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_TIN))).func_200464_a(arg_0), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151060_bw).func_200462_a(Character.valueOf('#'), ((FeatureItem)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)).item()).func_200462_a(Character.valueOf('X'), ApicultureItems.HONEYDEW.item()).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151127_ba).func_200472_a("#X#").func_200472_a("#Y#").func_200472_a("#X#").func_200465_a("has_melon", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151127_ba))).func_200464_a(arg_0), "apiculture");
        Object beesWax = CoreItems.BEESWAX.item();
        helper.moduleConditionRecipe(consumer -> ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_221657_bQ, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)beesWax).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a(" # ").func_200472_a(" # ").func_200472_a(" Y ").func_200465_a("has_wax", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)beesWax)).func_200467_a(consumer, new ResourceLocation("forestry", "torch_from_wax")), "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ApicultureItems.WAX_CAST.item()).func_200462_a(Character.valueOf('#'), beesWax).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_wax", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(beesWax))).func_200464_a(arg_0), "apiculture");
    }

    private void registerCombRecipes(RecipeDataHelper helper) {
        for (EnumHoneyComb honeyComb : EnumHoneyComb.VALUES) {
            Object comb = ((FeatureItem)ApicultureItems.BEE_COMBS.get(honeyComb)).item();
            Object combBlock = ((FeatureBlock)ApicultureBlocks.BEE_COMB.get(honeyComb)).block();
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(combBlock).func_200462_a(Character.valueOf('#'), comb).func_200472_a("##").func_200472_a("##").func_200465_a("has_comb", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(comb)).func_200473_b("combs")).func_200464_a(arg_0), "apiculture");
        }
    }

    private void registerArboricultureRecipes(RecipeDataHelper helper) {
        this.registerWoodRecipes(helper);
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ArboricultureItems.GRAFTER.item()).func_200469_a(Character.valueOf('B'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a("  B").func_200472_a(" # ").func_200472_a("#  ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE))).func_200464_a(arg_0), "arboriculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ArboricultureBlocks.TREE_CHEST.block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), (ITag)ItemTags.field_200037_g).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a(" # ").func_200472_a("XYX").func_200472_a("XXX").func_200465_a("has_sapling", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_200037_g))).func_200464_a(arg_0), "arboriculture");
    }

    private void registerWoodRecipes(RecipeDataHelper helper) {
        IWoodAccess woodAccess = TreeManager.woodAccess;
        List<IWoodType> woodTypes = woodAccess.getRegisteredWoodTypes();
        for (IWoodType woodType : woodTypes) {
            Block planks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, false).func_177230_c();
            Block fireproofPlanks = woodAccess.getBlock(woodType, WoodBlockKind.PLANKS, true).func_177230_c();
            Block log = woodAccess.getBlock(woodType, WoodBlockKind.LOG, false).func_177230_c();
            Block fireproofLog = woodAccess.getBlock(woodType, WoodBlockKind.LOG, true).func_177230_c();
            Block door = woodAccess.getBlock(woodType, WoodBlockKind.DOOR, false).func_177230_c();
            Block fence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, false).func_177230_c();
            Block fireproofFence = woodAccess.getBlock(woodType, WoodBlockKind.FENCE, true).func_177230_c();
            Block fencegate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, false).func_177230_c();
            Block fireproofFencegate = woodAccess.getBlock(woodType, WoodBlockKind.FENCE_GATE, true).func_177230_c();
            Block slab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, false).func_177230_c();
            Block fireproofSlab = woodAccess.getBlock(woodType, WoodBlockKind.SLAB, true).func_177230_c();
            Block stairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, false).func_177230_c();
            Block fireproofStairs = woodAccess.getBlock(woodType, WoodBlockKind.STAIRS, true).func_177230_c();
            if (woodType instanceof EnumForestryWoodType) {
                helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200488_a((IItemProvider)planks, (int)4).func_200487_b((IItemProvider)log).func_200483_a("has_log", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)log)).func_200490_a("planks")).func_200482_a(arg_0), "arboriculture");
                helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)fence, (int)3).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)planks).func_200472_a("W#W").func_200472_a("W#W").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)planks)).func_200473_b("wooden_fence")).func_200464_a(arg_0), "arboriculture");
                helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)fencegate).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)planks).func_200472_a("#W#").func_200472_a("#W#").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)planks)).func_200473_b("wooden_fence_gate")).func_200464_a(arg_0), "arboriculture");
                helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)planks).func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)planks)).func_200473_b("wooden_slab")).func_200464_a(arg_0), "arboriculture");
                helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)planks).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)planks)).func_200473_b("wooden_stairs")).func_200464_a(arg_0), "arboriculture");
            }
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)door, (int)3).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{planks, fireproofPlanks})).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)planks)).func_200473_b("wooden_door")).func_200464_a(arg_0), "arboriculture");
            helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200488_a((IItemProvider)fireproofPlanks, (int)4).func_200487_b((IItemProvider)fireproofLog).func_200483_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)fireproofPlanks)).func_200490_a("planks")).func_200482_a(arg_0), "arboriculture");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)fireproofFence, (int)3).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)fireproofPlanks).func_200472_a("W#W").func_200472_a("W#W").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)fireproofPlanks)).func_200473_b("wooden_fence")).func_200464_a(arg_0), "arboriculture");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)fireproofFencegate).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)fireproofPlanks).func_200472_a("#W#").func_200472_a("#W#").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)fireproofPlanks)).func_200473_b("wooden_fence_gate")).func_200464_a(arg_0), "arboriculture");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)fireproofSlab, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)fireproofPlanks).func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)fireproofPlanks)).func_200473_b("wooden_slab")).func_200464_a(arg_0), "arboriculture");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)fireproofStairs, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)fireproofPlanks).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)fireproofPlanks)).func_200473_b("wooden_stairs")).func_200464_a(arg_0), "arboriculture");
        }
    }

    private void registerFoodRecipes(RecipeDataHelper helper) {
        Object waxCapsule = ((FeatureItem)FluidsItems.CONTAINERS.get(EnumContainerType.CAPSULE)).item();
        Object honeyDrop = ((FeatureItem)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)).item();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(FoodItems.AMBROSIA.item()).func_200462_a(Character.valueOf('#'), ApicultureItems.HONEYDEW.item()).func_200462_a(Character.valueOf('X'), ApicultureItems.ROYAL_JELLY.item()).func_200462_a(Character.valueOf('Y'), waxCapsule).func_200472_a("#Y#").func_200472_a("XXX").func_200472_a("###").func_200465_a("has royal_jelly", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(ApicultureItems.ROYAL_JELLY.item()))).func_200464_a(arg_0), "food");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(FoodItems.HONEY_POT.item()).func_200462_a(Character.valueOf('#'), honeyDrop).func_200462_a(Character.valueOf('X'), waxCapsule).func_200472_a("# #").func_200472_a(" X ").func_200472_a("# #").func_200465_a("has_drop", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(honeyDrop))).func_200464_a(arg_0), "food");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(FoodItems.HONEYED_SLICE.item()).func_200462_a(Character.valueOf('#'), honeyDrop).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151025_P).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_drop", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(honeyDrop))).func_200464_a(arg_0), "food");
    }

    private void registerBackpackRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.ADVENTURER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)Tags.Items.BONES).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_bone", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.BONES))).func_200464_a(arg_0), "backpacks");
        Object beeChest = ArboricultureBlocks.TREE_CHEST.block();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.APIARIST_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200462_a(Character.valueOf('Y'), beeChest).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_bee_chest", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(beeChest))).func_200464_a(arg_0), "backpacks", "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.BUILDER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200462_a(Character.valueOf('V'), (IItemProvider)Items.field_151119_aD).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_clay", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151119_aD))).func_200464_a(arg_0), "backpacks");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.DIGGER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_stone", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.STONE))).func_200464_a(arg_0), "backpacks");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.FORESTER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)ItemTags.field_200038_h).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_log", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_200038_h))).func_200464_a(arg_0), "backpacks");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.HUNTER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)Tags.Items.FEATHERS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_feather", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.FEATHERS))).func_200464_a(arg_0), "backpacks");
        Object butterflyChest = LepidopterologyBlocks.BUTTERFLY_CHEST.block();
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.LEPIDOPTERIST_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200462_a(Character.valueOf('V'), butterflyChest).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_butterfly_chest", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(butterflyChest))).func_200464_a(arg_0), "backpacks", "lepidopterology");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(BackpackItems.MINER_BACKPACK.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('V'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STRING).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("VYV").func_200472_a("X#X").func_200465_a("has_iron", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.INGOTS_IRON))).func_200464_a(arg_0), "backpacks");
    }

    private void registerCharcoalRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CharcoalBlocks.CHARCOAL.block()).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_196155_l).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_charcoal", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_196155_l))).func_200464_a(arg_0), "charcoal");
        helper.moduleConditionRecipe(consumer -> ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196155_l, (int)9).func_203221_a(ForestryTags.Items.CHARCOAL).func_200483_a("has_charcoal_block", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.CHARCOAL)).func_200485_a(consumer, new ResourceLocation("forestry", "charcoal_from_block")), "charcoal");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CharcoalBlocks.WOOD_PILE.block()).func_200469_a(Character.valueOf('L'), (ITag)ItemTags.field_200038_h).func_200472_a("LL").func_200472_a("LL").func_200465_a("has_log", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_200038_h))).func_200464_a(arg_0), "charcoal");
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(CharcoalBlocks.WOOD_PILE_DECORATIVE.block()).func_200487_b(CharcoalBlocks.WOOD_PILE.block()).func_200483_a("was_wood_pile", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CharcoalBlocks.WOOD_PILE.block()))).func_200482_a(arg_0), "charcoal");
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(CharcoalBlocks.WOOD_PILE.block()).func_200487_b(CharcoalBlocks.WOOD_PILE_DECORATIVE.block()).func_200483_a("has_decorative", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CharcoalBlocks.WOOD_PILE_DECORATIVE.block()))).func_200482_a(arg_0), new ResourceLocation("forestry", "wood_pile_from_decorative"), "charcoal");
    }

    private void registerClimatologyRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ClimatologyBlocks.HABITATFORMER.block()).func_200462_a(Character.valueOf('S'), CoreItems.STURDY_CASING.item()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('B'), ForestryTags.Items.GEARS_BRONZE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('C'), ((FeatureItem)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC)).item()).func_200462_a(Character.valueOf('T'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)).item()).func_200472_a("GRG").func_200472_a("TST").func_200472_a("BCB").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "climatology");
        helper.simpleConditionalRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(ClimatologyItems.HABITAT_SCREEN.item()).func_200469_a(Character.valueOf('G'), ForestryTags.Items.GEARS_BRONZE).func_200469_a(Character.valueOf('P'), (ITag)Tags.Items.GLASS_PANES).func_200469_a(Character.valueOf('I'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND).func_200472_a("IPI").func_200472_a("IPI").func_200472_a("DGD").func_200465_a("has_diamond", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.GEMS_DIAMOND))).func_200464_a(arg_0), new ICondition[]{new AndCondition(new ICondition[]{new ModuleEnabledCondition("forestry", "climatology"), new NotCondition((ICondition)new ModuleEnabledCondition("forestry", "factory"))})});
    }

    private void registerCoreRecipes(RecipeDataHelper helper) {
        Consumer<IFinishedRecipe> consumer = helper.getConsumer();
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.APATITE)}), CoreItems.APATITE, (float)0.5f, (int)200).func_218628_a("has_apatite_ore", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.APATITE)))).func_218635_a(consumer, new ResourceLocation("forestry", "apatite_from_blasting"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.TIN)}), CoreItems.INGOT_TIN, (float)0.5f, (int)200).func_218628_a("has_tin_ore", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.TIN)))).func_218635_a(consumer, new ResourceLocation("forestry", "tin_ingot_from_blasting"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.COPPER)}), CoreItems.INGOT_COPPER, (float)0.5f, (int)200).func_218628_a("has_copper_ore", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.COPPER)))).func_218635_a(consumer, new ResourceLocation("forestry", "copper_ingot_from_blasting"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PEAT}), CoreItems.ASH.item(), (float)0.0f, (int)200).func_218628_a("has_peat", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.PEAT)).func_218635_a(consumer, new ResourceLocation("forestry", "ash_from_peat_blasting"));
        ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ANALYZER)).block()).func_200462_a(Character.valueOf('T'), CoreItems.PORTABLE_ALYZER.item()).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("XTX").func_200472_a(" Y ").func_200472_a("X X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item())).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.APATITE)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.GEMS_APATITE).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_apatite", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEMS_APATITE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.BRONZE)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.COPPER)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_COPPER).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_copper", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_COPPER)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.TIN)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_apatite", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_TIN)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(CoreItems.BRONZE_PICKAXE.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a("###").func_200472_a(" X ").func_200472_a(" X ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(CoreItems.BRONZE_SHOVEL.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a(" # ").func_200472_a(" X ").func_200472_a(" X ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_BRONZE.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE))).func_200464_a(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_BRONZE.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_COPPER).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE))).func_200464_a(arg_0)).build(helper.getConsumer(), new ResourceLocation("forestry", "gear_bronze"));
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_COPPER.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_copper", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_COPPER))).func_200464_a(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_COPPER.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_COPPER).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_COPPER).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_copper", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_COPPER))).func_200464_a(arg_0)).build(helper.getConsumer(), new ResourceLocation("forestry", "gear_copper"));
        ConditionalRecipe.builder().addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition("forge", "gears/stone"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_TIN.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_STONE).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_tin", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_TIN))).func_200464_a(arg_0)).addCondition((ICondition)new TagEmptyCondition("forge", "gears/stone")).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.GEAR_TIN.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_COPPER).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_tin", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_TIN))).func_200464_a(arg_0)).build(helper.getConsumer(), new ResourceLocation("forestry", "gear_tin"));
        ShapelessRecipeBuilder.func_200486_a(CoreItems.INGOT_BRONZE.item()).func_203221_a(ForestryTags.Items.INGOTS_TIN).func_203221_a(ForestryTags.Items.INGOTS_COPPER).func_203221_a(ForestryTags.Items.INGOTS_COPPER).func_203221_a(ForestryTags.Items.INGOTS_COPPER).func_200483_a("has_tin", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_TIN)).func_200485_a(consumer, new ResourceLocation("forestry", "ingot_bronze_alloying"));
        ShapelessRecipeBuilder.func_200488_a(CoreItems.APATITE.item(), (int)9).func_203221_a(ForestryTags.Items.STORAGE_BLOCKS_APATITE).func_200483_a("has_block", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.STORAGE_BLOCKS_APATITE)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a(CoreItems.INGOT_BRONZE.item(), (int)9).func_203221_a(ForestryTags.Items.STORAGE_BLOCKS_BRONZE).func_200483_a("has_block", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.STORAGE_BLOCKS_BRONZE)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a(CoreItems.INGOT_COPPER.item(), (int)9).func_203221_a(ForestryTags.Items.STORAGE_BLOCKS_COPPER).func_200483_a("has_block", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.STORAGE_BLOCKS_COPPER)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a(CoreItems.INGOT_TIN.item(), (int)9).func_203221_a(ForestryTags.Items.STORAGE_BLOCKS_TIN).func_200483_a("has_block", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.STORAGE_BLOCKS_TIN)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a(CoreItems.KIT_PICKAXE.item()).func_200487_b(CoreItems.BRONZE_PICKAXE.item()).func_200487_b(CoreItems.CARTON.item()).func_200483_a("has_pickaxe", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.BRONZE_PICKAXE.item())).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a(CoreItems.KIT_SHOVEL.item()).func_200487_b(CoreItems.BRONZE_SHOVEL.item()).func_200487_b(CoreItems.CARTON.item()).func_200483_a("has_shovel", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.BRONZE_SHOVEL.item())).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a(CoreItems.SPECTACLES.item()).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.GLASS_PANES).func_200472_a(" X ").func_200472_a("Y Y").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(CoreItems.PIPETTE.item()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199904_a).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GLASS_PANES).func_200472_a("  #").func_200472_a(" X ").func_200472_a("X  ").func_200465_a("has_wool", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_199904_a)).func_200464_a(consumer);
        helper.simpleConditionalRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(CoreItems.PORTABLE_ALYZER.item()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS_PANES).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND).func_200472_a("X#X").func_200472_a("X#X").func_200472_a("RDR").func_200465_a("has_diamond", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.GEMS_DIAMOND))).func_200464_a(arg_0), new ICondition[]{new NotCondition((ICondition)new ModuleEnabledCondition("forestry", "factory"))});
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('#'), ((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).item()).func_200472_a(" # ").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_wisp", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).item())).func_200467_a(consumer, new ResourceLocation("forestry", "string_from_wisp"));
        ShapedRecipeBuilder.func_200470_a(CoreItems.STURDY_CASING.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_221672_ax, (int)4).func_200462_a(Character.valueOf('#'), ((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).item()).func_200472_a("# #").func_200472_a(" # ").func_200472_a("# #").func_200465_a("has_wisp", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(((FeatureItem)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP)).item())).func_200467_a(consumer, new ResourceLocation("cobweb_from_wisp"));
        ShapedRecipeBuilder.func_200470_a(CoreItems.WRENCH.item()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200472_a("# #").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_bronze", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_BRONZE)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a(CoreItems.COMPOST, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150346_d).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.CROPS_WHEAT).func_200472_a(" X ").func_200472_a("X#X").func_200472_a(" X ").func_200465_a("has_wheat", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.CROPS_WHEAT)).func_200467_a(consumer, new ResourceLocation("forestry", "compost_wheat"));
        ShapedRecipeBuilder.func_200468_a(CoreItems.COMPOST, (int)1).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150346_d).func_200469_a(Character.valueOf('X'), ForestryTags.Items.DUSTS_ASH).func_200472_a(" X ").func_200472_a("X#X").func_200472_a(" X ").func_200465_a("has_ash", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.DUSTS_ASH)).func_200467_a(consumer, new ResourceLocation("forestry", "compost_ash"));
        ShapedRecipeBuilder.func_200468_a(CoreItems.FERTILIZER_COMPOUND, (int)8).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_203440_u).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE).func_200472_a(" # ").func_200472_a(" X ").func_200472_a(" # ").func_200465_a("has_apatite", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEMS_APATITE)).func_200467_a(consumer, new ResourceLocation("forestry", "fertilizer_apatite"));
        ShapedRecipeBuilder.func_200468_a(CoreItems.FERTILIZER_COMPOUND, (int)16).func_200469_a(Character.valueOf('#'), ForestryTags.Items.DUSTS_ASH).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_apatite", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEMS_APATITE)).func_200467_a(consumer, new ResourceLocation("forestry", "fertilizer_ash"));
        ShapedRecipeBuilder.func_200468_a(CoreBlocks.HUMUS, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150346_d).func_200462_a(Character.valueOf('X'), CoreItems.COMPOST).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_compost", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.COMPOST)).func_200467_a(consumer, new ResourceLocation("forestry", "humus_compost"));
        ShapedRecipeBuilder.func_200468_a(CoreBlocks.HUMUS, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150346_d).func_200462_a(Character.valueOf('X'), CoreItems.FERTILIZER_COMPOUND).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_fertilizer", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.FERTILIZER_COMPOUND)).func_200467_a(consumer, new ResourceLocation("forestry", "humus_fertilizer"));
        TriConsumer bogRecipe = (amount, container, name) -> ShapedRecipeBuilder.func_200468_a(CoreBlocks.BOG_EARTH, (int)amount).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150346_d).func_200471_a(Character.valueOf('X'), (Ingredient)new ComplexIngredient((ItemStack)container)).func_200469_a(Character.valueOf('Y'), (ITag)ItemTags.field_203440_u).func_200472_a("#Y#").func_200472_a("YXY").func_200472_a("#Y#").func_200465_a("has_sand", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)ItemTags.field_203440_u)).func_200467_a(consumer, new ResourceLocation("forestry", "bog_earth_" + name));
        bogRecipe.accept((Object)6, (Object)new ItemStack((IItemProvider)Items.field_151131_as), (Object)"bucket");
        ItemStack canWater = FluidsItems.getContainer(EnumContainerType.CAN, (Fluid)Fluids.field_204546_a);
        ItemStack waxCapsuleWater = FluidsItems.getContainer(EnumContainerType.CAPSULE, (Fluid)Fluids.field_204546_a);
        ItemStack refractoryWater = FluidsItems.getContainer(EnumContainerType.REFRACTORY, (Fluid)Fluids.field_204546_a);
        bogRecipe.accept((Object)8, (Object)canWater, (Object)"can");
        bogRecipe.accept((Object)8, (Object)waxCapsuleWater, (Object)"wax_capsule");
        bogRecipe.accept((Object)8, (Object)refractoryWater, (Object)"refractory");
    }

    private void registerBookRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(CoreItems.FORESTERS_MANUAL).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(((FeatureItem)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)).item()).func_200483_a("has_book", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151122_aG))).func_200482_a(arg_0), new ResourceLocation("forestry", "foresters_manual_honeydrop"), "book", "apiculture");
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(CoreItems.FORESTERS_MANUAL).func_200487_b((IItemProvider)Items.field_151122_aG).func_203221_a((ITag)ItemTags.field_200037_g).func_200483_a("has_book", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151122_aG))).func_200482_a(arg_0), new ResourceLocation("forestry", "foresters_manual_sapling"), "book");
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(CoreItems.FORESTERS_MANUAL).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(LepidopterologyItems.BUTTERFLY_GE.item()).func_200483_a("has_book", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151122_aG))).func_200482_a(arg_0), new ResourceLocation("forestry", "foresters_manual_butterfly"), "book", "lepidopterology");
    }

    private EnumElectronTube getElectronTube(BlockTypePlanter planter) {
        switch (planter) {
            case ARBORETUM: {
                return EnumElectronTube.GOLD;
            }
            case FARM_CROPS: {
                return EnumElectronTube.BRONZE;
            }
            case PEAT_POG: {
                return EnumElectronTube.OBSIDIAN;
            }
            case FARM_MUSHROOM: {
                return EnumElectronTube.APATITE;
            }
            case FARM_GOURD: {
                return EnumElectronTube.LAPIS;
            }
            case FARM_NETHER: {
                return EnumElectronTube.BLAZE;
            }
            case FARM_ENDER: {
                return EnumElectronTube.ENDER;
            }
        }
        return null;
    }

    private void registerCultivationRecipes(RecipeDataHelper helper) {
        for (BlockTypePlanter planter : BlockTypePlanter.values()) {
            Object managed = ((FeatureBlock)CultivationBlocks.PLANTER.get(planter, BlockPlanter.Mode.MANAGED)).block();
            Object manual = ((FeatureBlock)CultivationBlocks.PLANTER.get(planter, BlockPlanter.Mode.MANUAL)).block();
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(managed).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('T'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(this.getElectronTube(planter))).item()).func_200462_a(Character.valueOf('C'), CoreItems.FLEXIBLE_CASING.item()).func_200462_a(Character.valueOf('B'), ((FeatureItem)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC)).item()).func_200472_a("GTG").func_200472_a("TCT").func_200472_a("GBG").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.FLEXIBLE_CASING.item()))).func_200464_a(arg_0), "cultivation");
            helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(manual).func_200487_b(managed).func_200483_a("has_managed", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(managed))).func_200482_a(arg_0), "cultivation");
            helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(managed).func_200487_b(manual).func_200483_a("has_manual", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(manual))).func_200482_a(arg_0), new ResourceLocation("forestry", managed.getRegistryName().func_110623_a() + "_from_manual"), "cultivation");
        }
    }

    private void registerDatabaseRecipes(RecipeDataHelper helper) {
        ArrayList features = Lists.newArrayList((Object[])new FeatureBlock[]{ApicultureBlocks.BEE_CHEST, ArboricultureBlocks.TREE_CHEST, LepidopterologyBlocks.BUTTERFLY_CHEST});
        ArrayList possibleSpecials = Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ApicultureItems.ROYAL_JELLY.getItem()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((FeatureItem)CoreItems.FRUITS.get(ItemFruit.EnumFruit.PLUM)).getItem()}), Ingredient.func_199805_a((ITag)Tags.Items.CHESTS_WOODEN)});
        Ingredient possibleSpecial = Ingredient.merge((Collection)possibleSpecials);
        for (FeatureBlock featureBlock1 : features) {
            for (FeatureBlock featureBlock2 : features) {
                if (featureBlock1.equals(featureBlock2)) continue;
                helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(DatabaseBlocks.DATABASE.block()).func_200462_a(Character.valueOf('#'), CoreItems.PORTABLE_ALYZER.item()).func_200471_a(Character.valueOf('C'), possibleSpecial).func_200462_a(Character.valueOf('S'), featureBlock1.block()).func_200462_a(Character.valueOf('F'), featureBlock2.block()).func_200469_a(Character.valueOf('W'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('I'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("I#I").func_200472_a("FYS").func_200472_a("WCW").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), new ResourceLocation("forestry", "database_" + featureBlock1.getIdentifier() + "_" + featureBlock2.getIdentifier()), "database", featureBlock1.getModuleId(), featureBlock2.getModuleId());
            }
        }
    }

    private void registerEnergyRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)EnergyBlocks.ENGINES.get(BlockTypeEngine.BIOGAS)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('V'), (IItemProvider)Items.field_221602_aD).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('Y'), ForestryTags.Items.GEARS_BRONZE).func_200472_a("###").func_200472_a(" X ").func_200472_a("YVY").func_200465_a("has_piston", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_221602_aD))).func_200464_a(arg_0), "energy");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)EnergyBlocks.ENGINES.get(BlockTypeEngine.CLOCKWORK)).block()).func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199905_b).func_200462_a(Character.valueOf('V'), (IItemProvider)Items.field_221602_aD).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151113_aN).func_200469_a(Character.valueOf('Z'), ForestryTags.Items.GEARS_COPPER).func_200472_a("###").func_200472_a(" X ").func_200472_a("ZVY").func_200465_a("has_piston", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_221602_aD))).func_200464_a(arg_0), "energy");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)EnergyBlocks.ENGINES.get(BlockTypeEngine.PEAT)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_COPPER).func_200462_a(Character.valueOf('V'), (IItemProvider)Items.field_221602_aD).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('Y'), ForestryTags.Items.GEARS_COPPER).func_200472_a("###").func_200472_a(" X ").func_200472_a("YVY").func_200465_a("has_piston", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_221602_aD))).func_200464_a(arg_0), "energy");
    }

    private void registerFactoryRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.BOTTLER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('X'), ((FeatureItem)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).item()).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CARPENTER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("XYX").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_COPPER).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("XYX").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200469_a(Character.valueOf('Z'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("XZX").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.FERMENTER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_BRONZE).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.MOISTENER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_COPPER).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.RAINMAKER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEARS_TIN).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.RAINTANK)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("XYX").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.SQUEEZER)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("XYX").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.STILL)).block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a("X#X").func_200472_a("#Y#").func_200472_a("X#X").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "factory");
    }

    private void registerFarmingRecipes(RecipeDataHelper helper) {
        for (EnumFarmMaterial material : EnumFarmMaterial.values()) {
            Item base = material.getBase().func_77973_b();
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.PLAIN, material)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)base).func_200462_a(Character.valueOf('C'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN)).item()).func_200469_a(Character.valueOf('W'), (ITag)ItemTags.field_202899_i).func_200469_a(Character.valueOf('I'), ForestryTags.Items.INGOTS_COPPER).func_200472_a("I#I").func_200472_a("WCW").func_200465_a("has_copper", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.INGOTS_COPPER))).func_200464_a(arg_0), "farming");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.GEARBOX, material)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)base).func_200469_a(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).func_200472_a(" # ").func_200472_a("TTT").func_200465_a("has_tin_gear", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEARS_TIN))).func_200464_a(arg_0), "farming");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.HATCH, material)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)base).func_200469_a(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).func_200469_a(Character.valueOf('D'), (ITag)ItemTags.field_212188_k).func_200472_a(" # ").func_200472_a("TDT").func_200465_a("has_tin_gear", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEARS_TIN))).func_200464_a(arg_0), "farming");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.VALVE, material)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)base).func_200469_a(Character.valueOf('T'), ForestryTags.Items.GEARS_TIN).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GLASS).func_200472_a(" # ").func_200472_a("XTX").func_200465_a("has_tin_gear", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEARS_TIN))).func_200464_a(arg_0), "farming");
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)FarmingBlocks.FARM.get(EnumFarmBlockType.CONTROL, material)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)base).func_200462_a(Character.valueOf('T'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)).item()).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200472_a(" # ").func_200472_a("XTX").func_200465_a("has_tin_gear", (ICriterionInstance)ForestryRecipeProvider.func_200409_a(ForestryTags.Items.GEARS_TIN))).func_200464_a(arg_0), "farming");
        }
    }

    private void registerFluidsRecipes(RecipeDataHelper helper) {
        ForestryFluids milk = ForestryFluids.MILK;
        for (EnumContainerType containerType : EnumContainerType.values()) {
            ItemStack filled = FluidsItems.getContainer(containerType, milk);
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_222070_lD).func_200471_a(Character.valueOf('A'), (Ingredient)new ComplexIngredient(filled)).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151110_aK).func_200472_a("AAA").func_200472_a("BEB").func_200472_a("CCC").func_200465_a("has_wheat", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151015_O))).func_200464_a(arg_0), new ResourceLocation("forestry", "cake_" + containerType.func_176610_l()), "fluids");
        }
    }

    private void registerLepidopterologyRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(LepidopterologyBlocks.BUTTERFLY_CHEST.block()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('X'), LepidopterologyItems.BUTTERFLY_GE.item()).func_200469_a(Character.valueOf('Y'), (ITag)Tags.Items.CHESTS_WOODEN).func_200472_a(" # ").func_200472_a("XYX").func_200472_a("XXX").func_200465_a("has_butterfly", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(LepidopterologyItems.BUTTERFLY_GE.item()))).func_200464_a(arg_0), "lepidopterology");
    }

    private void registerMailRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(MailItems.CATALOGUE.item()).func_200487_b((IItemProvider)Items.field_151122_aG).func_203221_a(ForestryTags.Items.STAMPS).func_200483_a("has_book", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151122_aG))).func_200482_a(arg_0), "mail");
        helper.moduleConditionRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.func_200486_a(((FeatureItem)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH)).item()).func_200487_b((IItemProvider)Items.field_151121_aF).func_200489_a(Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199805_a(ForestryTags.Items.PROPOLIS), Ingredient.func_199805_a((ITag)Tags.Items.SLIMEBALLS)}))).func_200483_a("has_paper", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151121_aF))).func_200482_a(arg_0), "mail");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.MAILBOX)).block()).func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.CHESTS_WOODEN).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200472_a(" # ").func_200472_a("#Y#").func_200472_a("XXX").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "mail");
        Item[] emptiedLetter = (Item[])MailItems.LETTERS.getRowFeatures(ItemLetter.Size.EMPTY).stream().map(FeatureItem::getItem).toArray(Item[]::new);
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151121_aF).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])emptiedLetter)).func_200472_a(" # ").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_paper", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151121_aF))).func_200464_a(arg_0), "mail");
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(((FeatureBlock)MailBlocks.BASE.get(BlockTypeMail.TRADE_STATION)).block()).func_200462_a(Character.valueOf('#'), (IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE)).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.CHESTS_WOODEN).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING.item()).func_200462_a(Character.valueOf('Z'), ((FeatureItem)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)).item()).func_200471_a(Character.valueOf('W'), (Ingredient)new ComplexIngredient(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]))).func_200472_a("Z#Z").func_200472_a("#Y#").func_200472_a("XWX").func_200465_a("has_casing", (ICriterionInstance)ForestryRecipeProvider.func_200403_a(CoreItems.STURDY_CASING.item()))).func_200464_a(arg_0), "mail");
        Ingredient glue = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199805_a(ForestryTags.Items.DROP_HONEY), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151123_aH})}));
        for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
            helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a(((FeatureItem)MailItems.STAMPS.get(stampDefinition)).item(), (int)9).func_200471_a(Character.valueOf('X'), stampDefinition.getCraftingIngredient()).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151121_aF).func_200471_a(Character.valueOf('Z'), glue).func_200472_a("XXX").func_200472_a("###").func_200472_a("ZZZ").func_200465_a("has_paper", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_151121_aF))).func_200464_a(arg_0), "mail");
        }
    }

    private void registerSortingRecipes(RecipeDataHelper helper) {
        Ingredient ing = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{LepidopterologyItems.CATERPILLAR_GE.item(), ((FeatureItem)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)).item()}), Ingredient.func_199805_a(ForestryTags.Items.FRUITS)}));
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a(SortingBlocks.FILTER.block(), (int)2).func_200469_a(Character.valueOf('B'), ForestryTags.Items.GEARS_BRONZE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND).func_200471_a(Character.valueOf('F'), ing).func_200469_a(Character.valueOf('W'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200472_a("WDW").func_200472_a("FGF").func_200472_a("BDB").func_200465_a("has_diamond", (ICriterionInstance)ForestryRecipeProvider.func_200409_a((ITag)Tags.Items.GEMS_DIAMOND))).func_200464_a(arg_0), "sorting");
    }

    private void registerWorktableRecipes(RecipeDataHelper helper) {
        helper.moduleConditionRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a(WorktableBlocks.WORKTABLE.block()).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200469_a(Character.valueOf('C'), (ITag)Tags.Items.CHESTS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_221734_cc).func_200472_a("B").func_200472_a("W").func_200472_a("C").func_200465_a("has_crafting_table", (ICriterionInstance)ForestryRecipeProvider.func_200403_a((IItemProvider)Items.field_221734_cc))).func_200464_a(arg_0), "worktable");
    }

    protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path pathIn) {
    }

    public String func_200397_b() {
        return "Forestry Recipes";
    }
}

