/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class CentrifugeRecipeBuilder {
    private int processingTime;
    private Ingredient input;
    private final NonNullList<ICentrifugeRecipe.Product> outputs = NonNullList.func_191196_a();

    public CentrifugeRecipeBuilder setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
        return this;
    }

    public CentrifugeRecipeBuilder setInput(Ingredient input) {
        this.input = input;
        return this;
    }

    public CentrifugeRecipeBuilder product(float chance, ItemStack itemStack) {
        this.outputs.add((Object)new ICentrifugeRecipe.Product(chance, itemStack));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.processingTime, this.input, this.outputs));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int processingTime;
        private final Ingredient input;
        private final NonNullList<ICentrifugeRecipe.Product> outputs;

        public Result(ResourceLocation id, int processingTime, Ingredient input, NonNullList<ICentrifugeRecipe.Product> outputs) {
            this.id = id;
            this.processingTime = processingTime;
            this.input = input;
            this.outputs = outputs;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.processingTime);
            json.add("input", this.input.func_200304_c());
            JsonArray products = new JsonArray();
            for (ICentrifugeRecipe.Product product : this.outputs) {
                JsonObject object = new JsonObject();
                object.addProperty("chance", (Number)Float.valueOf(product.getProbability()));
                object.add("item", (JsonElement)RecipeSerializers.item(product.getStack()));
                products.add((JsonElement)object);
            }
            json.add("products", (JsonElement)products);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ICentrifugeRecipe.Companion.SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

