/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.data.builder.Holder;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeBuilder {
    private Ingredient plan;
    private FluidStack molten;
    private ShapedRecipeBuilder.Result recipe;

    public FabricatorRecipeBuilder setPlan(Ingredient plan) {
        this.plan = plan;
        return this;
    }

    public FabricatorRecipeBuilder setMolten(FluidStack molten) {
        this.molten = molten;
        return this;
    }

    public FabricatorRecipeBuilder recipe(ShapedRecipeBuilder recipe) {
        Holder holder = new Holder();
        recipe.func_200465_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200464_a(holder::set);
        this.recipe = (ShapedRecipeBuilder.Result)holder.get();
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.plan, this.molten, this.recipe));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient plan;
        private final FluidStack molten;
        private final ShapedRecipeBuilder.Result recipe;

        public Result(ResourceLocation id, Ingredient plan, FluidStack molten, ShapedRecipeBuilder.Result recipe) {
            this.id = id;
            this.plan = plan;
            this.molten = molten;
            this.recipe = recipe;
        }

        public void func_218610_a(JsonObject json) {
            json.add("plan", this.plan.func_200304_c());
            json.add("molten", (JsonElement)RecipeSerializers.serializeFluid(this.molten));
            json.add("recipe", (JsonElement)this.recipe.func_200441_a());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IFabricatorRecipe.Companion.SERIALIZER;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

