/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class MoistenerRecipeBuilder {
    private int timePerItem;
    private Ingredient resource;
    private ItemStack product;

    public MoistenerRecipeBuilder setTimePerItem(int timePerItem) {
        this.timePerItem = timePerItem;
        return this;
    }

    public MoistenerRecipeBuilder setResource(Ingredient resource) {
        this.resource = resource;
        return this;
    }

    public MoistenerRecipeBuilder setProduct(ItemStack product) {
        this.product = product;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.timePerItem, this.resource, this.product));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int timePerItem;
        private final Ingredient resource;
        private final ItemStack product;

        public Result(ResourceLocation id, int timePerItem, Ingredient resource, ItemStack product) {
            this.id = id;
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.timePerItem);
            json.add("resource", this.resource.func_200304_c());
            json.add("product", (JsonElement)RecipeSerializers.item(this.product));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IMoistenerRecipe.Companion.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

