/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipeBuilder {
    private int processingTime;
    private NonNullList<Ingredient> resources;
    private FluidStack fluidOutput;
    private ItemStack remnants = ItemStack.field_190927_a;
    private float remnantsChance;

    public SqueezerRecipeBuilder setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
        return this;
    }

    public SqueezerRecipeBuilder setResources(NonNullList<Ingredient> resources) {
        this.resources = resources;
        return this;
    }

    public SqueezerRecipeBuilder setFluidOutput(FluidStack fluidOutput) {
        this.fluidOutput = fluidOutput;
        return this;
    }

    public SqueezerRecipeBuilder setRemnants(ItemStack remnants) {
        this.remnants = remnants;
        return this;
    }

    public SqueezerRecipeBuilder setRemnantsChance(float remnantsChance) {
        this.remnantsChance = remnantsChance;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.processingTime, this.resources, this.fluidOutput, this.remnants, this.remnantsChance));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int processingTime;
        private final NonNullList<Ingredient> resources;
        private final FluidStack fluidOutput;
        private final ItemStack remnants;
        private final float remnantsChance;

        public Result(ResourceLocation id, int processingTime, NonNullList<Ingredient> resources, FluidStack fluidOutput, ItemStack remnants, float remnantsChance) {
            this.id = id;
            this.processingTime = processingTime;
            this.resources = resources;
            this.fluidOutput = fluidOutput;
            this.remnants = remnants;
            this.remnantsChance = remnantsChance;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.processingTime);
            JsonArray resources = new JsonArray();
            for (Ingredient resource : this.resources) {
                resources.add(resource.func_200304_c());
            }
            json.add("resources", (JsonElement)resources);
            json.add("output", (JsonElement)RecipeSerializers.serializeFluid(this.fluidOutput));
            json.add("remnant", (JsonElement)RecipeSerializers.item(this.remnants));
            json.addProperty("chance", (Number)Float.valueOf(this.remnantsChance));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ISqueezerRecipe.Companion.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

