/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import forestry.core.entities.MinecartEntityForestry;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public abstract class MinecartEntityContainerForestry
extends MinecartEntityForestry
implements ISidedInventory,
IFilterSlotDelegate,
INamedContainerProvider {
    private boolean dropContentsWhenDead = true;

    public MinecartEntityContainerForestry(EntityType<? extends MinecartEntityContainerForestry> type, World world) {
        super(type, world);
    }

    public MinecartEntityContainerForestry(EntityType<?> type, World world, double posX, double posY, double posZ) {
        super(type, world, posX, posY, posZ);
    }

    protected void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.getInternalInventory().read(compoundNBT);
    }

    protected void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        this.getInternalInventory().write(compoundNBT);
    }

    public void func_70106_y() {
        if (this.dropContentsWhenDead && !this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.getInternalInventory());
        }
        super.func_70106_y();
    }

    protected void func_94101_h() {
        int redstoneLevel = 15 - Container.func_94526_b((IInventory)this);
        double drag = 0.98f + (float)redstoneLevel * 0.001f;
        this.func_213317_d(this.func_213322_ci().func_216372_d(drag, 0.0, drag));
    }

    @Nullable
    public Entity changeDimension(ServerWorld p_241206_1_, ITeleporter teleporter) {
        this.dropContentsWhenDead = false;
        return super.changeDimension(p_241206_1_, teleporter);
    }

    protected abstract IInventoryAdapter getInternalInventory();

    public boolean func_191420_l() {
        return this.getInternalInventory().func_191420_l();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.func_70089_S() && (double)player.func_70032_d((Entity)this) <= 64.0;
    }

    public int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(PlayerEntity player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(PlayerEntity player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("MINECART_TITLE_GOES_HERE");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] func_180463_a(Direction side) {
        return this.getInternalInventory().func_180463_a(side);
    }

    public boolean func_180462_a(int slot, ItemStack stack, Direction side) {
        return this.getInternalInventory().func_180462_a(slot, stack, side);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction side) {
        return this.getInternalInventory().func_180461_b(slot, stack, side);
    }

    public void func_70296_d() {
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }
}

