/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.FakeTankUpdateHandler;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.TankManager;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class StandardTank
extends FluidTank
implements IStreamable {
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private ITankUpdateHandler tankUpdateHandler = FakeTankUpdateHandler.instance;
    private int tankIndex;
    private final boolean canFill;
    private final boolean canDrain;
    private boolean internalTest;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected ToolTip toolTip;

    public StandardTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity);
        this.canDrain = canDrain;
        this.canFill = canFill;
    }

    public StandardTank(int capacity) {
        super(capacity);
        this.canFill = true;
        this.canDrain = true;
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public void setTankUpdateHandler(TankManager tankUpdateHandler) {
        this.tankUpdateHandler = tankUpdateHandler;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public int getColor() {
        Fluid f = this.getFluidType();
        if (f == null) {
            return 0xFFFFFF;
        }
        return f.getAttributes().getColor(this.getFluid());
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getFluidAmount();
    }

    @Nullable
    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.internalTest || this.validator.test(stack);
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canFill() || !this.isFluidValid(resource)) {
            return 0;
        }
        return this.fillInternal(resource, action);
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        this.internalTest = true;
        int filled = super.fill(resource, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && filled > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        this.internalTest = false;
        return filled;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(maxDrain, action);
    }

    @Nonnull
    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && !drained.isEmpty() && drained.getAmount() > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(resource, action);
    }

    @Nonnull
    public FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && !drained.isEmpty() && drained.getAmount() > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    public String toString() {
        return String.format("Tank: %s, %d/%d", !this.fluid.isEmpty() ? this.fluid.getFluid().getRegistryName() : "Empty", this.getFluidAmount(), this.getCapacity());
    }

    protected boolean hasFluid() {
        FluidStack fluid = this.getFluid();
        return !fluid.isEmpty() && fluid.getAmount() > 0 && fluid.getFluid() != Fluids.field_204541_a;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeFluidStack(this.fluid);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.fluid = data.readFluidStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new TankToolTip(this);
        }
        return this.toolTip;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshTooltip() {
        ToolTip toolTip = this.getToolTip();
        toolTip.clear();
        int amount = 0;
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            Fluid fluidType = fluidStack.getFluid();
            FluidAttributes attributes = fluidType.getAttributes();
            Rarity rarity = attributes.getRarity();
            if (rarity == null) {
                rarity = Rarity.COMMON;
            }
            toolTip.add((ITextComponent)new TranslationTextComponent(attributes.getTranslationKey(fluidStack)), rarity.field_77937_e);
            amount = this.getFluid().getAmount();
        }
        TranslationTextComponent liquidAmount = new TranslationTextComponent("for.gui.tooltip.liquid.amount", new Object[]{amount, this.getCapacity()});
        toolTip.add((ITextComponent)liquidAmount);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class TankToolTip
    extends ToolTip {
        private final StandardTank standardTank;

        public TankToolTip(StandardTank standardTank) {
            this.standardTank = standardTank;
        }

        @Override
        public void refresh() {
            this.standardTank.refreshTooltip();
        }
    }
}

