/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.ISpeciesDisplayHelper;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import net.minecraft.item.ItemStack;

public class SpeciesDisplayHelper
implements ISpeciesDisplayHelper {
    private final Table<IOrganismType, String, ItemStack> iconStacks = HashBasedTable.create();
    private final IForestrySpeciesRoot<IIndividual> root;

    public SpeciesDisplayHelper(IForestrySpeciesRoot<IIndividual> root) {
        this.root = root;
        IOrganismType type = root.getIconType();
        for (IIndividual individual : root.getIndividualTemplates()) {
            ItemStack itemStack = root.getTypes().createStack(individual, type);
            this.iconStacks.put((Object)type, (Object)individual.getGenome().getPrimary().getRegistryName().toString(), (Object)itemStack);
        }
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species, IOrganismType type) {
        ItemStack stack = (ItemStack)this.iconStacks.get((Object)type, (Object)species.getRegistryName().toString());
        if (stack == null) {
            stack = this.root.getTypes().createStack(this.root.templateAsIndividual(this.root.getTemplates().getTemplate(species.getRegistryName().toString())), type);
            this.iconStacks.put((Object)type, (Object)species.getRegistryName().toString(), (Object)stack);
        }
        return stack;
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species) {
        return this.getDisplayStack(species, this.root.getIconType());
    }
}

