/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.analyzer;

import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.core.genetics.analyzer.DatabaseTab;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.LayoutHelper;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.components.ComponentKeys;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IWorld;

public class MutationsTab
extends DatabaseTab {
    public MutationsTab(Supplier<ItemStack> stackSupplier) {
        super("mutations", stackSupplier);
    }

    @Override
    public void createElements(DatabaseElement container, IIndividual individual, ItemStack itemStack) {
        IGenome genome = individual.getGenome();
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)individual.getRoot();
        IAlleleSpecies species = genome.getPrimary();
        IMutationContainer mutationContainer = (IMutationContainer)speciesRoot.getComponent(ComponentKeys.MUTATIONS);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((IWorld)player.field_70170_p, player.func_146103_bH());
        LayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.horizontal(16, 0, new Insets(0, 1, 0, 0)), 100, 16);
        Collection<? extends IMutation> mutations = this.getValidMutations(mutationContainer.getCombinations(species));
        if (!mutations.isEmpty()) {
            container.label(Translator.translateToLocal("for.gui.database.mutations.further"), Alignment.TOP_CENTER, GuiConstants.UNDERLINED_STYLE);
            mutations.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutation(0, 0, 50, 16, (IMutation)mutation, species, breedingTracker)));
            groupHelper.finish(true);
        }
        if ((mutations = this.getValidMutations(mutationContainer.getResultantMutations(species))).isEmpty()) {
            return;
        }
        container.label(Translator.translateToLocal("for.gui.database.mutations.resultant"), Alignment.TOP_CENTER, GuiConstants.UNDERLINED_STYLE);
        mutations.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutationResultant(0, 0, 50, 16, (IMutation)mutation, breedingTracker)));
        groupHelper.finish(true);
    }

    private Collection<? extends IMutation> getValidMutations(List<? extends IMutation> mutations) {
        mutations.removeIf(IMutation::isSecret);
        return mutations;
    }
}

