/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.climate.IClimateProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MutationConditionHumidity
implements IMutationCondition {
    private final EnumHumidity minHumidity;
    private final EnumHumidity maxHumidity;

    public MutationConditionHumidity(EnumHumidity minHumidity, EnumHumidity maxHumidity) {
        this.minHumidity = minHumidity;
        this.maxHumidity = maxHumidity;
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        EnumHumidity biomeHumidity = climate.getHumidity();
        if (biomeHumidity.ordinal() < this.minHumidity.ordinal() || biomeHumidity.ordinal() > this.maxHumidity.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public ITextComponent getDescription() {
        String minHumidityString = AlleleManager.climateHelper.toDisplay(this.minHumidity).getString();
        if (this.minHumidity != this.maxHumidity) {
            String maxHumidityString = AlleleManager.climateHelper.toDisplay(this.maxHumidity).getString();
            return new StringTextComponent(Translator.translateToLocal("for.mutation.condition.humidity.range").replace("%LOW", minHumidityString).replace("%HIGH", maxHumidityString));
        }
        return new TranslationTextComponent("for.mutation.condition.humidity.single", new Object[]{minHumidityString});
    }
}

