/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.core.features.CoreItems;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootDefinition;
import genetics.utils.RootUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IWorld;

public class ContainerAnalyzerProviderHelper {
    private final PlayerEntity player;
    private final ContainerForestry container;
    @Nullable
    private final ItemInventoryAlyzer alyzerInventory;

    public ContainerAnalyzerProviderHelper(ContainerForestry container, PlayerInventory playerInventory) {
        this.player = playerInventory.field_70458_d;
        this.container = container;
        ItemInventoryAlyzer alyzerInventory = null;
        int analyzerIndex = -1;
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (stack.func_190926_b() || !CoreItems.PORTABLE_ALYZER.itemEqual(stack)) continue;
            analyzerIndex = i;
            alyzerInventory = new ItemInventoryAlyzer(playerInventory.field_70458_d, stack);
            Slot slot = container.func_75139_a(i < 9 ? i + 27 : i - 9);
            if (!(slot instanceof SlotLockable)) break;
            SlotLockable lockable = (SlotLockable)slot;
            lockable.lock();
            break;
        }
        int analyzerIndex1 = analyzerIndex;
        this.alyzerInventory = alyzerInventory;
        if (alyzerInventory != null) {
            container.func_75146_a(new SlotAnalyzer(alyzerInventory, 0, -110, 20));
        }
    }

    @Nullable
    public Slot getAnalyzerSlot() {
        if (this.alyzerInventory == null) {
            return null;
        }
        for (Slot slot : this.container.field_75151_b) {
            if (!(slot instanceof SlotAnalyzer)) continue;
            return slot;
        }
        return null;
    }

    public void analyzeSpecimen(int selectedSlot) {
        IIndividual individual;
        IRootDefinition definition;
        if (selectedSlot < 0 || this.alyzerInventory == null) {
            return;
        }
        Slot specimenSlot = this.container.getForestrySlot(selectedSlot);
        ItemStack specimen = specimenSlot.func_75211_c();
        if (specimen.func_190926_b()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            specimenSlot.func_75215_d(convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if (!(definition = RootUtils.getRoot(specimen)).isPresent()) {
            return;
        }
        IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)definition.get();
        Optional optionalIndividual = speciesRoot.create(specimen);
        if (optionalIndividual.isPresent() && !(individual = (IIndividual)optionalIndividual.get()).isAnalyzed()) {
            boolean requiresEnergy = ModuleHelper.isEnabled("apiculture");
            ItemStack energyStack = this.alyzerInventory.func_70301_a(0);
            if (requiresEnergy && !ItemInventoryAlyzer.isAlyzingFuel(energyStack)) {
                return;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker((IWorld)this.player.field_70170_p, this.player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                specimen = specimen.func_77946_l();
                GeneticHelper.setIndividual(specimen, individual);
                if (requiresEnergy) {
                    this.alyzerInventory.func_70298_a(0, 1);
                }
            }
            specimenSlot.func_75215_d(specimen);
        }
    }
}

