/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.packets.PacketErrorUpdateEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;

public class ContainerEntity<T extends Entity>
extends ContainerForestry {
    protected final T entity;
    @Nullable
    private ImmutableSet<IErrorState> previousErrorStates;

    protected ContainerEntity(int windowId, ContainerType<?> type, T entity) {
        super(windowId, type);
        this.entity = entity;
    }

    protected ContainerEntity(int windowId, ContainerType<?> type, T entity, PlayerInventory playerInventory, int xInv, int yInv) {
        this(windowId, type, entity);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(PlayerEntity player) {
        return true;
    }

    public final boolean func_75145_c(PlayerEntity PlayerEntity2) {
        return ((IInventory)this.entity).func_70300_a(PlayerEntity2);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.entity instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.entity;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates == null || !errorStates.equals(this.previousErrorStates)) {
                PacketErrorUpdateEntity packet = new PacketErrorUpdateEntity((Entity)this.entity, errorLogicSource);
                this.sendPacketToListeners(packet);
            }
            this.previousErrorStates = errorStates;
        }
    }
}

