/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Drawable {
    public final int u;
    public final int v;
    public final int uWidth;
    public final int vHeight;
    public final ResourceLocation textureLocation;
    private final int textureWidth;
    private final int textureHeight;

    public Drawable(ResourceLocation textureLocation, int u, int v, int uWidth, int vHeight) {
        this(textureLocation, u, v, uWidth, vHeight, 256, 256);
    }

    public Drawable(ResourceLocation textureLocation, int u, int v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.textureLocation = textureLocation;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public void draw(MatrixStack transform, int yOffset, int xOffset) {
        this.draw(transform, yOffset, this.uWidth, this.vHeight, xOffset);
    }

    public void draw(MatrixStack transform, int yOffset, int width, int height, int xOffset) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(this.textureLocation);
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.func_238466_a_((MatrixStack)transform, (int)xOffset, (int)yOffset, (int)width, (int)height, (float)this.u, (float)this.v, (int)this.uWidth, (int)this.vHeight, (int)this.textureWidth, (int)this.textureHeight);
        RenderSystem.disableAlphaTest();
    }
}

