/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.core.gui.elements.ActionOrigin;
import forestry.core.gui.elements.ActionType;
import java.util.EnumMap;

public class ActionConfig {
    private final EnumMap<ActionType, ActionOrigin> actionOrigins;

    public static ActionConfig self() {
        return ActionConfig.selfBuilder().create();
    }

    public static ActionConfig all() {
        return ActionConfig.allBuilder().create();
    }

    public static Builder selfBuilder() {
        return ActionConfig.builder(ActionOrigin.SELF);
    }

    public static Builder allBuilder() {
        return ActionConfig.builder(ActionOrigin.ALL);
    }

    public static Builder builder(ActionOrigin origin) {
        return new Builder(origin);
    }

    public ActionConfig(EnumMap<ActionType, ActionOrigin> actionOrigins) {
        this.actionOrigins = actionOrigins;
    }

    public ActionOrigin get(ActionType type) {
        return this.actionOrigins.get((Object)type);
    }

    public boolean has(ActionType type, ActionOrigin origin) {
        return this.get(type) == origin;
    }

    public static class Builder {
        private final EnumMap<ActionType, ActionOrigin> permissions = new EnumMap(ActionType.class);

        public Builder(ActionOrigin origin) {
            for (ActionType event : ActionType.values()) {
                this.permissions.put(event, origin);
            }
        }

        public Builder self(ActionType ... events) {
            return this.set(ActionOrigin.SELF, events);
        }

        public Builder all(ActionType ... events) {
            return this.set(ActionOrigin.ALL, events);
        }

        public Builder set(ActionOrigin origin, ActionType ... events) {
            for (ActionType event : events) {
                this.permissions.put(event, origin);
            }
            return this;
        }

        public ActionConfig create() {
            return new ActionConfig(this.permissions);
        }
    }
}

