/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.elements.ActionConfig;
import forestry.core.gui.elements.ActionOrigin;
import forestry.core.gui.elements.ActionType;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.ElementBuilder;
import forestry.core.gui.elements.ITooltipSupplier;
import forestry.core.gui.elements.Window;
import forestry.core.gui.elements.layouts.ContainerElement;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiElement
extends AbstractGui {
    public static final int UNKNOWN_HEIGHT = -1;
    public static final int UNKNOWN_WIDTH = -1;
    public static final Dimension UNKNOWN_SIZE = new Dimension(-1, -1);
    private final List<ITooltipSupplier> tooltipSuppliers = new ArrayList<ITooltipSupplier>();
    @Nullable
    protected Point preferredPos;
    protected Dimension preferredSize = UNKNOWN_SIZE;
    @Nullable
    protected Rectangle bounds;
    protected int cropX;
    protected int cropY;
    protected int cropWidth = -1;
    protected int cropHeight = -1;
    @Nullable
    protected GuiElement cropElement = null;
    private Alignment align = Alignment.TOP_LEFT;
    protected boolean visible = true;
    @Nullable
    protected GuiElement parent;
    protected final ActionConfig actionConfig;

    @Deprecated
    protected GuiElement(int xPos, int yPos) {
        this();
        this.setPos(xPos, yPos);
    }

    @Deprecated
    protected GuiElement(int xPos, int yPos, int width, int height) {
        this();
        this.setPreferredBounds(xPos, yPos, width, height);
    }

    protected GuiElement() {
        this.actionConfig = this.buildActions(ActionConfig.selfBuilder()).create();
    }

    protected GuiElement(ElementBuilder<?, ?> builder) {
        this.setSize(builder.size.width, builder.size.height);
        if (builder.pos != null) {
            this.setPos(builder.pos.x, builder.pos.y);
        }
        this.setAlign(builder.align);
        this.visible = builder.defaultVisibility;
        this.tooltipSuppliers.addAll(builder.tooltipSuppliers);
        this.actionConfig = this.buildActions(builder.actionsCallback.apply(ActionConfig.builder(builder.defaultOrigin))).create();
    }

    public final int getX() {
        return this.bounds != null ? this.bounds.x : 0;
    }

    public final int getY() {
        return this.bounds != null ? this.bounds.y : 0;
    }

    public final int getAbsoluteX() {
        return this.parent == null ? this.getX() : this.getX() + this.parent.getAbsoluteX();
    }

    public final int getAbsoluteY() {
        return this.parent == null ? this.getY() : this.getY() + this.parent.getAbsoluteY();
    }

    public final void draw(MatrixStack transform, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.getX(), (float)this.getY(), (float)0.0f);
        if (this.isCropped()) {
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow window = mc.func_228018_at_();
            double scaleWidth = (double)window.func_198105_m() / (double)window.func_198107_o();
            double scaleHeight = (double)window.func_198083_n() / (double)window.func_198087_p();
            GuiElement cropRelative = this.cropElement != null ? this.cropElement : this;
            int posX = cropRelative.getAbsoluteX();
            int posY = cropRelative.getAbsoluteY();
            GL11.glScissor((int)((int)((double)(posX + this.cropX) * scaleWidth)), (int)((int)((double)window.func_198083_n() - (double)(posY + this.cropY + this.cropHeight) * scaleHeight)), (int)((int)((double)this.cropWidth * scaleWidth)), (int)((int)((double)this.cropHeight * scaleHeight)));
        }
        this.drawElement(transform, mouseX, mouseY);
        if (this.isCropped()) {
            GL11.glDisable((int)3089);
        }
        RenderSystem.popMatrix();
    }

    protected void drawElement(MatrixStack transform, int mouseX, int mouseY) {
    }

    public void afterLayout() {
    }

    public int getWidth() {
        if (this.bounds != null) {
            return this.bounds.width;
        }
        return this.preferredSize.width;
    }

    public int getHeight() {
        if (this.bounds != null) {
            return this.bounds.height;
        }
        return this.preferredSize.height;
    }

    public Dimension getLayoutSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Nullable
    public Point getPreferredPos() {
        return this.preferredPos;
    }

    @Nullable
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setHeight(int height) {
        this.setSize(this.preferredSize.width, height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.preferredSize.height);
    }

    public GuiElement setSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
        return this;
    }

    public GuiElement setXPosition(int xPos) {
        this.setLocation(xPos, this.preferredPos != null ? this.preferredPos.y : 0);
        return this;
    }

    public GuiElement setYPosition(int yPos) {
        this.setLocation(this.preferredPos != null ? this.preferredPos.x : 0, yPos);
        return this;
    }

    public GuiElement setLocation(int xPos, int yPos) {
        this.preferredPos = new Point(xPos, yPos);
        this.requestLayout();
        return this;
    }

    public GuiElement setPreferredBounds(int xPos, int yPos, int width, int height) {
        this.setLocation(xPos, yPos);
        this.setSize(width, height);
        return this;
    }

    public void setAssignedBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public GuiElement setAlign(Alignment align) {
        this.align = align;
        return this;
    }

    public Alignment getAlign() {
        return this.align;
    }

    public void setCroppedZone(@Nullable GuiElement cropElement, int cropX, int cropY, int cropWidth, int cropHeight) {
        this.cropElement = cropElement;
        this.cropX = cropX;
        this.cropY = cropY;
        this.cropWidth = cropWidth;
        this.cropHeight = cropHeight;
    }

    @Nullable
    public GuiElement getCropElement() {
        return this.cropElement;
    }

    public int getCropX() {
        return this.cropX;
    }

    public int getCropY() {
        return this.cropY;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    public boolean isCropped() {
        return this.cropElement != null && this.cropWidth >= 0 && this.cropHeight >= 0;
    }

    public Window getWindow() {
        if (this.parent == null) {
            throw new IllegalStateException("Tried to access the window element of an element that doesn't had one.");
        }
        return this.parent.getWindow();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!this.isVisible()) {
            return false;
        }
        return mouseX >= 0.0 && mouseX < (double)this.getWidth() && mouseY >= 0.0 && mouseY < (double)this.getHeight();
    }

    public final boolean isMouseOver() {
        Window window = this.getWindow();
        int mouseX = window.getRelativeMouseX(this);
        int mouseY = window.getRelativeMouseY(this);
        if (!this.isCropped()) {
            return this.isMouseOver(mouseX, mouseY);
        }
        GuiElement cropRelative = this.cropElement != null ? this.cropElement : this;
        int posX = cropRelative.getAbsoluteX() - this.getAbsoluteX();
        int posY = cropRelative.getAbsoluteY() - this.getAbsoluteY();
        boolean inCrop = mouseX >= posX && mouseY >= posY && mouseX <= posX + this.cropWidth && mouseY <= posY + this.cropHeight;
        return inCrop && this.isMouseOver(mouseX, mouseY);
    }

    protected void onUpdateClient() {
    }

    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.onUpdateClient();
    }

    public boolean isVisible() {
        return this.visible && (this.parent == null || this.parent.isVisible());
    }

    public void show() {
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
    }

    public boolean isEnabled() {
        return this.parent == null || this.parent.isEnabled();
    }

    public boolean canMouseOver() {
        return this.hasTooltip();
    }

    public boolean canFocus() {
        return false;
    }

    @Nullable
    public GuiElement getParent() {
        return this.parent;
    }

    public GuiElement setParent(@Nullable GuiElement parent) {
        this.parent = parent;
        return this;
    }

    public ToolTip getTooltip(int mouseX, int mouseY) {
        ToolTip toolTip = new ToolTip();
        this.tooltipSuppliers.stream().filter(ITooltipSupplier::hasTooltip).forEach(supplier -> supplier.addTooltip(toolTip, this, mouseX, mouseY));
        return toolTip;
    }

    public GuiElement addTooltip(ITextComponent line) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> toolTip.add(line));
        return this;
    }

    public GuiElement addTooltip(Collection<ITextComponent> lines) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> {
            TextCollection cfr_ignored_0 = (TextCollection)toolTip.addAll(lines);
        });
        return this;
    }

    public GuiElement addTooltip(Supplier<ITextComponent> line) {
        this.addTooltip((ToolTip toolTip, GuiElement element, int mouseX, int mouseY) -> toolTip.add((ITextComponent)line.get()));
        return this;
    }

    public GuiElement addTooltip(ITooltipSupplier supplier) {
        this.tooltipSuppliers.add(supplier);
        return this;
    }

    public boolean hasTooltip() {
        return !this.tooltipSuppliers.isEmpty();
    }

    public void clearTooltip() {
        this.tooltipSuppliers.clear();
    }

    public ToolTip getTooltip() {
        int mouseX = this.getWindow().getRelativeMouseX(this);
        int mouseY = this.getWindow().getRelativeMouseY(this);
        ToolTip toolTip = new ToolTip();
        this.tooltipSuppliers.stream().filter(ITooltipSupplier::hasTooltip).forEach(supplier -> supplier.addTooltip(toolTip, this, mouseX, mouseY));
        return toolTip;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public boolean hasOrigin(ActionType type, ActionOrigin origin) {
        return this.actionConfig.has(type, origin) || origin == ActionOrigin.SELF_TOP && this.actionConfig.has(type, ActionOrigin.SELF) || (origin == ActionOrigin.SELF || origin == ActionOrigin.SELF_TOP) && this.actionConfig.has(type, ActionOrigin.ALL);
    }

    protected ActionConfig.Builder buildActions(ActionConfig.Builder builder) {
        return builder;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double dWheel) {
        return false;
    }

    public void onMouseMove(double mouseX, double mouseY) {
    }

    public void onMouseEnter(double mouseX, double mouseY) {
    }

    public void onMouseLeave(double mouseX, double mouseY) {
    }

    public boolean onMouseDrag(double mouseX, double mouseY) {
        return false;
    }

    public void onDragStart(double mouseX, double mouseY) {
    }

    public void onDragEnd(double mouseX, double mouseY) {
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean onCharTyped(char keyCode, int modifiers) {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("bounds", (Object)this.bounds).add("a", (Object)this.align).add("v", this.isVisible()).toString();
    }

    public GuiElement setPos(int x, int y) {
        this.preferredPos = new Point(x, y);
        this.requestLayout();
        return this;
    }

    public void requestLayout() {
        if (!(this.parent instanceof ContainerElement)) {
            return;
        }
        ((ContainerElement)this.parent).markDirty();
    }
}

