/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.gatgets.IDatabasePlugin;
import forestry.api.genetics.gatgets.IGeneticAnalyzer;
import forestry.api.genetics.gatgets.IGeneticAnalyzerProvider;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiConstants;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DrawableElement;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ItemElement;
import forestry.core.gui.elements.Window;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.elements.layouts.FlexLayout;
import forestry.core.render.ColourProperties;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.mutation.IMutation;
import java.awt.Insets;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class GuiElementFactory
implements ISelectiveResourceReloadListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/database_mutation_screen.png");
    public Style dominantStyle = Style.field_240709_b_;
    public Style recessiveStyle = Style.field_240709_b_;
    public Style guiStyle = Style.field_240709_b_;
    public Style guiTitleStyle = Style.field_240709_b_;
    public Style databaseTitle = Style.field_240709_b_;
    public Style binomial = Style.field_240709_b_;
    private static final Drawable QUESTION_MARK = new Drawable(TEXTURE, 78, 240, 16, 16);
    private static final Drawable DOWN_SYMBOL = new Drawable(TEXTURE, 0, 247, 15, 9);
    private static final Drawable UP_SYMBOL = new Drawable(TEXTURE, 15, 247, 15, 9);
    private static final Drawable BOOTH_SYMBOL = new Drawable(TEXTURE, 30, 247, 15, 9);
    private static final Drawable NONE_SYMBOL = new Drawable(TEXTURE, 45, 247, 15, 9);
    public static final GuiElementFactory INSTANCE = new GuiElementFactory();

    private GuiElementFactory() {
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.dominantStyle = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColourProperties.INSTANCE.get("gui.beealyzer.dominant")));
        this.recessiveStyle = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColourProperties.INSTANCE.get("gui.beealyzer.recessive")));
        this.guiStyle = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColourProperties.INSTANCE.get("gui.screen")));
        this.guiTitleStyle = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColourProperties.INSTANCE.get("gui.title")));
        this.databaseTitle = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)13612347)).setUnderlined(Boolean.valueOf(true));
        this.binomial = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColourProperties.INSTANCE.get("gui.beealyzer.binomial")));
    }

    public IGeneticAnalyzer createAnalyzer(Window window, int xPos, int yPos, boolean rightBoarder, IGeneticAnalyzerProvider provider) {
        return new GeneticAnalyzer(window, xPos, yPos, rightBoarder, provider);
    }

    public static ContainerElement horizontal(int height, int spacing, Insets margin) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.horizontal(spacing, margin)).setSize(-1, height);
    }

    public static ContainerElement vertical(int width, int spacing, Insets margin) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.vertical(spacing, margin)).setSize(width, -1);
    }

    public static ContainerElement horizontal(int height, int spacing) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.horizontal(spacing)).setSize(-1, height);
    }

    public static ContainerElement vertical(int width, int spacing) {
        return (ContainerElement)new ContainerElement().setLayout(FlexLayout.vertical(spacing)).setSize(width, -1);
    }

    public static ContainerElement pane() {
        return new ContainerElement();
    }

    public static ContainerElement pane(int width, int height) {
        return (ContainerElement)new ContainerElement().setSize(width, height);
    }

    public static ContainerElement pane(int xPos, int yPos, int width, int height) {
        return (ContainerElement)new ContainerElement().setPreferredBounds(xPos, yPos, width, height);
    }

    public final int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }

    public final Style getStateStyle(boolean dominant) {
        return dominant ? this.dominantStyle : this.recessiveStyle;
    }

    public final Style getGuiStyle() {
        return this.guiStyle;
    }

    public GuiElement createFertilityInfo(IAlleleValue<Integer> fertilityAllele, int texOffset) {
        String fertilityString = fertilityAllele.getValue() + " x";
        ContainerElement layout = GuiElementFactory.horizontal(-1, 2);
        layout.label(fertilityString, this.getStateStyle(fertilityAllele.isDominant()));
        layout.drawable(0, -1, new Drawable(TEXTURE, 60, 240 + texOffset, 12, 8));
        return layout;
    }

    public GuiElement createToleranceInfo(IAlleleValue<EnumTolerance> toleranceAllele, IAlleleForestrySpecies species, String text) {
        ContainerElement layout = GuiElementFactory.horizontal(-1, 0);
        layout.label(text, this.getStateStyle(species.isDominant()));
        layout.add(this.createToleranceInfo(toleranceAllele));
        return layout;
    }

    public GuiElement createToleranceInfo(IAlleleValue<EnumTolerance> toleranceAllele) {
        Style textStyle = this.getStateStyle(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        StringTextComponent component = null;
        ContainerElement layout = GuiElementFactory.horizontal(-1, 2);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                layout.add(GuiElementFactory.createBothSymbol(0, -1));
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                layout.add(GuiElementFactory.createDownSymbol(0, -1));
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                layout.add(GuiElementFactory.createUpSymbol(0, -1));
                break;
            }
            default: {
                layout.add(GuiElementFactory.createNoneSymbol(0, -1));
                component = new StringTextComponent("(0)");
            }
        }
        if (component == null) {
            component = new StringTextComponent("(").func_230529_a_(toleranceAllele.getDisplayName()).func_240702_b_(")");
        }
        layout.label((ITextComponent)component).setStyle(textStyle);
        return layout;
    }

    public GuiElement createMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            ContainerElement element = new ContainerElement();
            element.setPreferredBounds(x, y, width, height);
            IAlyzerPlugin plugin = ((IForestrySpeciesRoot)mutation.getRoot()).getAlyzerPlugin();
            Map<ResourceLocation, ItemStack> iconStacks = plugin.getIconStacks();
            ItemStack firstPartner = iconStacks.get(mutation.getFirstParent().getRegistryName());
            ItemStack secondPartner = iconStacks.get(mutation.getSecondParent().getRegistryName());
            element.add(new ItemElement(0, 0, firstPartner), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), new ItemElement(33, 0, secondPartner));
            return element;
        }
        if (mutation.isSecret()) {
            return null;
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation);
    }

    @Nullable
    public ContainerElement createMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        if (breedingTracker.isDiscovered(mutation)) {
            ContainerElement element = GuiElementFactory.pane(x, y, width, height);
            IForestrySpeciesRoot speciesRoot = (IForestrySpeciesRoot)mutation.getRoot();
            int speciesIndex = speciesRoot.getKaryotype().getSpeciesType().ordinal();
            IDatabasePlugin plugin = speciesRoot.getSpeciesPlugin();
            Map<String, ItemStack> iconStacks = plugin.getIndividualStacks();
            ItemStack partner = iconStacks.get(mutation.getPartner(species).getRegistryName().toString());
            IAllele resultAllele = mutation.getTemplate()[speciesIndex];
            ItemStack result = iconStacks.get(resultAllele.getRegistryName().toString());
            element.add(new ItemElement(0, 0, partner), new ItemElement(33, 0, result));
            GuiElementFactory.createProbabilityArrow(element, mutation, 18, 4, breedingTracker);
            return element;
        }
        if (mutation.isSecret()) {
            return null;
        }
        return GuiElementFactory.createUnknownMutationGroup(x, y, width, height, mutation, breedingTracker);
    }

    private static ContainerElement createUnknownMutationGroup(int x, int y, int width, int height, IMutation mutation) {
        ContainerElement element = GuiElementFactory.pane(x, y, width, height);
        element.add(GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createProbabilityAdd(mutation, 21, 4), GuiElementFactory.createQuestionMark(32, 0));
        return element;
    }

    private static ContainerElement createUnknownMutationGroup(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        ContainerElement element = GuiElementFactory.pane(x, y, width, height);
        element.add(GuiElementFactory.createQuestionMark(0, 0), GuiElementFactory.createQuestionMark(32, 0));
        GuiElementFactory.createProbabilityArrow(element, mutation, 18, 4, breedingTracker);
        return element;
    }

    private static void createProbabilityArrow(ContainerElement element, IMutation combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getBaseChance();
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
                break;
            }
        }
        element.drawable(x, y, new Drawable(TEXTURE, column, line, 15, 9));
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            element.label("+").setStyle(GuiConstants.DEFAULT_STYLE).setAlign(Alignment.TOP_LEFT).setSize(10, 10).setLocation(x + 9, y + 1);
        }
    }

    private static DrawableElement createProbabilityAdd(IMutation mutation, int x, int y) {
        float chance = mutation.getBaseChance();
        int line = 247;
        int column = 190;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 190;
                break;
            }
            case HIGHER: {
                column = 199;
                break;
            }
            case HIGH: {
                column = 208;
                break;
            }
            case NORMAL: {
                column = 217;
                break;
            }
            case LOW: {
                column = 226;
                break;
            }
            case LOWEST: {
                column = 235;
                break;
            }
        }
        return new DrawableElement(x, y, new Drawable(TEXTURE, column, line, 9, 9));
    }

    private static DrawableElement createQuestionMark(int x, int y) {
        return new DrawableElement(x, y, QUESTION_MARK);
    }

    private static DrawableElement createDownSymbol(int x, int y) {
        return new DrawableElement(x, y, DOWN_SYMBOL);
    }

    private static DrawableElement createUpSymbol(int x, int y) {
        return new DrawableElement(x, y, UP_SYMBOL);
    }

    private static DrawableElement createBothSymbol(int x, int y) {
        return new DrawableElement(x, y, BOOTH_SYMBOL);
    }

    private static DrawableElement createNoneSymbol(int x, int y) {
        return new DrawableElement(x, y, NONE_SYMBOL);
    }
}

