/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.climate.IClimatised;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ClimateLedger
extends Ledger {
    private final IClimatised tile;

    public ClimateLedger(LedgerManager manager, IClimatised tile) {
        super(manager, "climate");
        this.tile = tile;
        this.maxHeight = 72;
    }

    @Override
    public void draw(MatrixStack transform, int y, int x) {
        EnumTemperature temperature = this.tile.getTemperature();
        this.drawBackground(transform, y, x);
        this.drawSprite(transform, temperature.getSprite(), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(transform, Translator.translateToLocal("for.gui.climate"), x + 22, y + 8);
        this.drawSubheader(transform, Translator.translateToLocal("for.gui.temperature") + ':', x + 22, y + 20);
        this.drawText(transform, AlleleManager.climateHelper.toDisplay(temperature).getString() + ' ' + StringUtil.floatAsPercent(this.tile.getExactTemperature()), x + 22, y + 32);
        this.drawSubheader(transform, Translator.translateToLocal("for.gui.humidity") + ':', x + 22, y + 44);
        this.drawText(transform, AlleleManager.climateHelper.toDisplay(this.tile.getHumidity()).getString() + ' ' + StringUtil.floatAsPercent(this.tile.getExactHumidity()), x + 22, y + 56);
    }

    @Override
    public ITextComponent getTooltip() {
        return new StringTextComponent("T: ").func_230529_a_(AlleleManager.climateHelper.toDisplay(this.tile.getTemperature())).func_230529_a_((ITextComponent)new StringTextComponent(" / H: ")).func_230529_a_(AlleleManager.climateHelper.toDisplay(this.tile.getHumidity()));
    }
}

