/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.owner.IOwnedTile;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class OwnerLedger
extends Ledger {
    @Nullable
    private final GameProfile owner;

    public OwnerLedger(LedgerManager manager, IOwnedTile tile) {
        super(manager, "owner");
        this.owner = tile.getOwnerHandler().getOwner();
        this.maxHeight = 40;
    }

    @Override
    public boolean isVisible() {
        return this.owner != null;
    }

    @Override
    public void draw(MatrixStack transform, int y, int x) {
        this.drawBackground(transform, y, x);
        TextureAtlasSprite accessIcon = TextureManagerForestry.getInstance().getDefault("misc/access.shared");
        this.drawSprite(transform, accessIcon, x + 3, y + 4);
        if (this.isFullyOpened()) {
            this.drawHeader(transform, Translator.translateToLocal("for.gui.owner"), x + 22, y + 8);
            this.drawText(transform, PlayerUtil.getOwnerName(this.owner), x + 22, y + 20);
        }
    }

    @Override
    public ITextComponent getTooltip() {
        return new TranslationTextComponent("for.gui.owner").func_240702_b_(": " + PlayerUtil.getOwnerName(this.owner));
    }
}

