/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.config.Constants;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryPlain;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.InventoryUtil;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class InventoryAdapter
implements IInventoryAdapter,
IStreamable {
    private final InventoryPlain inventory;
    private boolean allowAutomation = true;
    @Nullable
    private int[] slotMap;

    public InventoryAdapter(int size, String name) {
        this(size, name, 64);
    }

    public InventoryAdapter(int size, String name, int stackLimit) {
        this(new InventoryPlain(size, name, stackLimit));
    }

    public InventoryAdapter(InventoryPlain inventory) {
        this.inventory = inventory;
        this.configureSided();
    }

    public InventoryAdapter disableAutomation() {
        this.allowAutomation = false;
        return this;
    }

    public InventoryAdapter copy() {
        InventoryAdapter copy = new InventoryAdapter(this.inventory.func_70302_i_(), "TEST_TITLE_PLEASE_IGNORE", this.inventory.func_70297_j_());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i).func_190926_b()) continue;
            copy.func_70299_a(i, this.inventory.func_70301_a(i).func_77946_l());
        }
        return copy;
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.inventory.func_70304_b(slotIndex);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public int[] func_180463_a(Direction side) {
        if (this.allowAutomation && this.slotMap != null) {
            return this.slotMap;
        }
        return Constants.SLOTS_NONE;
    }

    private void configureSided() {
        int count = this.func_70302_i_();
        this.slotMap = new int[count];
        for (int i = 0; i < count; ++i) {
            this.slotMap[i] = i;
        }
    }

    public boolean func_180462_a(int slot, ItemStack stack, Direction side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction side) {
        return false;
    }

    @Override
    public void read(CompoundNBT compoundNBT) {
        InventoryUtil.readFromNBT((IInventory)this, this.inventory.getName(), compoundNBT);
    }

    @Override
    public CompoundNBT write(CompoundNBT compoundNBT) {
        InventoryUtil.writeToNBT((IInventory)this, this.inventory.getName(), compoundNBT);
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeInventory(this.inventory);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        data.readInventory(this.inventory);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

