/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.arboriculture.TreeManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import forestry.modules.ModuleHelper;
import genetics.utils.RootUtils;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryAnalyzer
extends InventoryAdapterTile<TileAnalyzer> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_INPUT_COUNT = 6;
    public static final short SLOT_OUTPUT_1 = 8;
    public static final short SLOT_OUTPUT_COUNT = 4;

    public InventoryAnalyzer(TileAnalyzer analyzer) {
        super(analyzer, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 2, 6)) {
            return RootUtils.isIndividual(itemStack) || GeneticsUtil.getGeneticEquivalent(itemStack).isPresent();
        }
        if (slotIndex == 1) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluid.map(f -> ((TileAnalyzer)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, Direction side) {
        return SlotUtil.isSlotInRange(slotIndex, 8, 4);
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        if (ModuleHelper.isEnabled("arboriculture") && !TreeManager.treeRoot.isMember(itemStack)) {
            itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack);
        }
        super.func_70299_a(slotId, itemStack);
    }
}

