/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class ConditionLootModifier
extends LootModifier {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation tableLocation;
    private final String[] extensions;
    private boolean operates = false;

    public ConditionLootModifier(ResourceLocation location, String ... extensions) {
        super(new ILootCondition[]{LootTableIdCondition.builder((ResourceLocation)location).build()});
        this.tableLocation = location;
        this.extensions = extensions;
    }

    private static ILootCondition[] merge(ILootCondition[] conditions, ILootCondition condition) {
        ILootCondition[] newArray = Arrays.copyOf(conditions, conditions.length + 1);
        newArray[conditions.length] = condition;
        return newArray;
    }

    private ConditionLootModifier(ILootCondition[] conditions, ResourceLocation location, String ... extensions) {
        super(ConditionLootModifier.merge(conditions, LootTableIdCondition.builder((ResourceLocation)location).build()));
        this.tableLocation = location;
        this.extensions = extensions;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.operates) {
            return generatedLoot;
        }
        this.operates = true;
        for (String extension : this.extensions) {
            ResourceLocation location = new ResourceLocation("forestry", this.tableLocation.func_110623_a() + "/" + extension);
            LootTable table = context.func_227502_a_(location);
            if (table == LootTable.field_186464_a) continue;
            generatedLoot.addAll(table.func_216113_a(context));
        }
        this.operates = false;
        return generatedLoot;
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<ConditionLootModifier> {
        public Serializer() {
            this.setRegistryName("forestry", "condition_modifier");
        }

        public ConditionLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            String table = JSONUtils.func_151200_h((JsonObject)object, (String)"table");
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"extensions");
            String[] extensions = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                extensions[i] = array.get(i).getAsString();
            }
            if (conditions == null) {
                return new ConditionLootModifier(new ResourceLocation(table), extensions);
            }
            return new ConditionLootModifier(conditions, new ResourceLocation(table), extensions);
        }

        public JsonObject write(ConditionLootModifier instance) {
            JsonObject obj = new JsonObject();
            obj.addProperty("table", instance.tableLocation.toString());
            JsonArray extensions = new JsonArray();
            for (String value : instance.extensions) {
                extensions.add(value);
            }
            obj.add("extensions", (JsonElement)extensions);
            return obj;
        }
    }
}

