/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import genetics.api.alleles.IAllele;
import genetics.api.individual.ISpeciesDefinition;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.utils.RootUtils;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class OrganismFunction
extends LootFunction {
    public static LootFunctionType type;
    private final ResourceLocation speciesUid;

    private OrganismFunction(ILootCondition[] conditions, ResourceLocation speciesUid) {
        super(conditions);
        this.speciesUid = speciesUid;
    }

    public static LootFunction.Builder<?> fromDefinition(ISpeciesDefinition<?> definition) {
        return OrganismFunction.fromUID(definition.getSpecies().getRegistryName());
    }

    public static LootFunction.Builder<?> fromUID(ResourceLocation speciesUid) {
        return OrganismFunction.func_215860_a(conditions -> new OrganismFunction((ILootCondition[])conditions, speciesUid));
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext lootContext) {
        IRootDefinition<IIndividualRoot> definition = RootUtils.getRoot(stack);
        return definition.map(root -> {
            Optional<IOrganismType> speciesType = root.getType(stack);
            return speciesType.map(type -> {
                IAllele[] template = root.getTemplate(this.speciesUid.toString());
                if (template.length > 0) {
                    Object individual = root.templateAsIndividual(template);
                    return root.createStack(individual, (IOrganismType)speciesType.get());
                }
                return stack;
            }).orElse(stack);
        }).orElse(stack);
    }

    public LootFunctionType func_230425_b_() {
        return type;
    }

    public static class Serializer
    extends LootFunction.Serializer<OrganismFunction> {
        public void serialize(JsonObject object, OrganismFunction function, JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)function, context);
            object.addProperty("speciesUid", function.speciesUid.toString());
        }

        public OrganismFunction deserialize(JsonObject object, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] conditions) {
            String speciesUid = JSONUtils.func_151200_h((JsonObject)object, (String)"speciesUid");
            return new OrganismFunction(conditions, new ResourceLocation(speciesUid));
        }
    }
}

